/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.command;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.block.BlockFundamentals;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.loader.KBlockDefinition;
import snownee.kiwi.customization.command.ReloadSlotsCommand;
import snownee.kiwi.util.resource.OneTimeLoader;

public class ReloadBlockSettingsCommand {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.literal((String)"block_settings").executes(ctx -> ReloadBlockSettingsCommand.reload((CommandSourceStack)ctx.getSource())));
    }

    private static int reload(CommandSourceStack source) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        OneTimeLoader.Context context = new OneTimeLoader.Context();
        BlockFundamentals fundamentals = BlockFundamentals.reload(CustomizationHooks.collectKiwiPacks(), context, false);
        long parseTime = stopwatch.elapsed().toMillis();
        stopwatch.reset().start();
        HashSet set = Sets.newHashSet();
        BuiltInRegistries.BLOCK.holders().forEach(holder -> {
            KBlockDefinition definition = fundamentals.blocks().get(holder.key().location());
            if (definition == null || !set.add((Block)holder.value())) {
                return;
            }
            KBlockSettings.Builder builder = definition.createSettings(holder.key().location(), fundamentals.shapes());
            ((Block)holder.value()).properties = builder.get();
            KBlockDefinition.setConfiguringShape((Block)holder.value());
        });
        Blocks.rebuildCache();
        ReloadSlotsCommand.reload(fundamentals);
        long attachTime = stopwatch.elapsed().toMillis();
        Kiwi.LOGGER.info("Parse time %dms + Attach time %dms = %dms".formatted(parseTime, attachTime, parseTime + attachTime));
        source.sendSuccess(() -> Component.literal((String)"%d Block settings reloaded".formatted(set.size())), false);
        return 1;
    }
}

