/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.builder.BlockSpread;
import snownee.kiwi.customization.builder.BuilderRule;

public record ReplaceBuilderRule(Map<BlockFamily, Object> families, BlockSpread spread) implements BuilderRule
{
    @Override
    public Stream<Block> relatedBlocks() {
        return this.families.keySet().stream().flatMap(BlockFamily::blocks);
    }

    @Override
    public boolean matches(Player player, ItemStack itemStack, BlockState blockState) {
        if (itemStack.is(blockState.getBlock().asItem())) {
            return false;
        }
        return this.relatedBlocks().anyMatch(block -> itemStack.is(block.asItem()));
    }

    @Override
    public void apply(UseOnContext context, List<BlockPos> positions) {
        ItemStack itemStack = context.getItemInHand().copy();
        Item item = itemStack.getItem().asItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem item2 = (BlockItem)item;
        BlockPlaceContext placeContext = new BlockPlaceContext(context);
        Player player = context.getPlayer();
        Level level = context.getLevel();
        boolean success = false;
        for (BlockPos pos : positions) {
            BlockState oldBlock = level.getBlockState(pos);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 4);
            placeContext = BlockPlaceContext.at((BlockPlaceContext)placeContext, (BlockPos)pos, (Direction)context.getClickedFace());
            if (item2.place(placeContext) == InteractionResult.FAIL) {
                level.setBlock(pos, oldBlock, 4);
            } else {
                success = true;
            }
            if (player == null) continue;
            player.setItemInHand(context.getHand(), itemStack);
        }
        if (success && player != null) {
            BlockState blockState = item2.getBlock().defaultBlockState();
            SoundType soundType = blockState.getSoundType();
            level.playSound(null, player.blockPosition(), soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        }
    }

    @Override
    public List<BlockPos> searchPositions(UseOnContext context) {
        List<BlockPos> list = List.of();
        try {
            list = this.spread.collect(context, (Predicate<Block>)Predicates.alwaysTrue());
        }
        catch (Exception e) {
            Kiwi.LOGGER.error("Failed to collect positions", (Throwable)e);
        }
        return list;
    }
}

