/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class ItemButton
extends Button {
    private final ItemStack itemStack;
    private final boolean inContainer;
    private float hoverProgress;

    protected ItemButton(Builder builder) {
        super((Button.Builder)builder);
        this.itemStack = builder.itemStack;
        this.inContainer = builder.inContainer;
    }

    public static Builder builder(ItemStack itemStack, boolean inContainer, Button.OnPress pOnPress) {
        return new Builder(itemStack, inContainer, pOnPress);
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth() - 1;
        int height = this.getHeight() - 1;
        if (this.inContainer) {
            pGuiGraphics.fill(x + 1, y + 1, x + width - 1, y + height - 1, 0x222222 | (int)(this.alpha * 255.0f) << 24);
        } else {
            pGuiGraphics.fill(x, y, x + width, y + height, 0x222222 | (int)(this.alpha * 255.0f) << 24);
        }
        this.hoverProgress += this.isHoveredOrFocused() ? pPartialTick * 0.2f : -pPartialTick * 0.2f;
        this.hoverProgress = Mth.clamp((float)this.hoverProgress, (float)(this.inContainer ? 0.0f : 0.4f), (float)1.0f);
        int lineColor = 0xFFFFFF | (int)(this.hoverProgress * 255.0f) << 24;
        pGuiGraphics.fill(x, y, x + 1, y + height, lineColor);
        pGuiGraphics.fill(x + width - 1, y, x + width, y + height, lineColor);
        pGuiGraphics.fill(x + 1, y, x + width - 1, y + 1, lineColor);
        pGuiGraphics.fill(x + 1, y + height - 1, x + width - 1, y + height, lineColor);
        pGuiGraphics.renderItem(this.itemStack, x + 2, y + 2);
    }

    public static class Builder
    extends Button.Builder {
        private final ItemStack itemStack;
        private final boolean inContainer;

        protected Builder(ItemStack itemStack, boolean inContainer, Button.OnPress pOnPress) {
            super(itemStack.getHoverName(), pOnPress);
            this.itemStack = itemStack;
            this.inContainer = inContainer;
        }

        public ItemButton build() {
            return new ItemButton(this);
        }
    }
}

