/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.builder.FacingLimitation;
import snownee.kiwi.customization.placement.StatePropertiesPredicate;

public record BlockSpread(Type type, Optional<StatePropertiesPredicate> statePropertiesPredicate, FacingLimitation facingLimitation, int maxDistance) {
    public List<BlockPos> collect(UseOnContext context, Predicate<Block> blockPredicate) {
        return this.collect((BlockGetter)context.getLevel(), context.getClickedPos(), Objects.requireNonNull(context.getPlayer()), blockPredicate);
    }

    public List<BlockPos> collect(BlockGetter level, BlockPos origin, Player player, Predicate<Block> blockPredicate) {
        BlockState originalBlock = level.getBlockState(origin);
        Direction direction = player.getDirection();
        Direction originalDirection = Direction.NORTH;
        try {
            String s = KBlockUtils.getValueString(originalBlock, "facing");
            originalDirection = Direction.valueOf((String)s.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception s) {
            // empty catch block
        }
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                List<BlockPos> list2;
                List<Object> list = List.of();
                if (this.facingLimitation.test(originalDirection, direction) && (list = this.collectPlaneXZ(level, origin, originalBlock, direction)).size() > 1) {
                    yield list;
                }
                if (this.facingLimitation.test(originalDirection, direction.getClockWise()) && (list2 = this.collectPlaneXZ(level, origin, originalBlock, direction.getClockWise())).size() > list.size()) {
                    yield list2;
                }
                yield list;
            }
            case 1 -> this.collectPlaneXYZ(level, origin, originalBlock, player);
        };
    }

    private List<BlockPos> collectPlaneXYZ(BlockGetter level, BlockPos origin, BlockState originalBlock, Player player) {
        throw new NotImplementedException();
    }

    private List<BlockPos> collectPlaneXZ(BlockGetter level, BlockPos origin, BlockState originalBlock, Direction direction) {
        ArrayList list = Lists.newArrayList((Object[])new BlockPos[]{origin});
        PlacePosIterator iterator = new PlacePosIterator(origin, this.maxDistance, direction);
        while (iterator.hasNext()) {
            BlockPos next = iterator.next();
            BlockState blockState = level.getBlockState(next);
            if (!blockState.is(originalBlock.getBlock()) || this.statePropertiesPredicate.isPresent() && !this.statePropertiesPredicate.get().smartTest(originalBlock, blockState)) continue;
            list.add(next);
            iterator.add(next, null);
        }
        return list;
    }

    public static enum Type {
        PLANE_XZ,
        PLANE_XYZ;

    }

    static class PlacePosIterator
    extends PosIterator {
        final Direction direction;

        PlacePosIterator(BlockPos origin, int maxDistance, Direction direction) {
            super(origin, maxDistance);
            this.direction = direction;
        }

        @Override
        public Stream<BlockPos> listPossibleNext(BlockPos cur, @Nullable BlockPos from) {
            Stream.Builder<BlockPos> builder = Stream.builder();
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    BlockPos next;
                    if (i == 0 && j == 0 || (next = cur.relative(this.direction, i).relative(Direction.UP, j)).equals((Object)from)) continue;
                    builder.accept(next);
                }
            }
            return builder.build();
        }
    }

    static abstract class PosIterator
    implements Iterator<BlockPos> {
        final LongSet visited = new LongAVLTreeSet();
        final Queue<BlockPos> queue = Lists.newLinkedList();
        final BlockPos origin;
        final int maxDistance;

        PosIterator(BlockPos origin, int maxDistance) {
            this.origin = origin;
            this.maxDistance = maxDistance;
        }

        @Override
        public boolean hasNext() {
            if (this.visited.isEmpty()) {
                this.add(this.origin, null);
            }
            return !this.queue.isEmpty();
        }

        @Override
        public BlockPos next() {
            return this.queue.poll();
        }

        public void add(BlockPos cur, @Nullable BlockPos from) {
            if (this.origin.distManhattan((Vec3i)cur) > this.maxDistance) {
                return;
            }
            this.visited.add(cur.asLong());
            this.listPossibleNext(cur, from).filter(pos -> {
                long l = pos.asLong();
                if (this.visited.contains(l)) {
                    return false;
                }
                this.visited.add(l);
                return true;
            }).forEach(this.queue::add);
        }

        public abstract Stream<BlockPos> listPossibleNext(BlockPos var1, @Nullable BlockPos var2);
    }
}

