/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.family;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.util.KHolder;

public class StonecutterRecipeMaker {
    private static final Cache<Item, List<RecipeHolder<StonecutterRecipe>>> EXCHANGE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.of(1L, ChronoUnit.MINUTES)).build();
    private static final Cache<Item, List<RecipeHolder<StonecutterRecipe>>> SOURCE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.of(1L, ChronoUnit.MINUTES)).build();

    public static <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> appendRecipesFor(List<RecipeHolder<T>> recipes, C input) {
        ItemStack itemStack = input.getItem(0);
        if (itemStack.isEmpty()) {
            return recipes;
        }
        Item item = itemStack.getItem();
        List exchangeRecipes = List.of();
        try {
            Collection<KHolder<BlockFamily>> families = BlockFamilies.find(item);
            if (!families.isEmpty()) {
                exchangeRecipes = (List)EXCHANGE_CACHE.get((Object)item, () -> {
                    ArrayList list = null;
                    for (KHolder family : families) {
                        if (!((BlockFamily)family.value()).stonecutterExchange()) continue;
                        if (list == null) {
                            list = Lists.newArrayList();
                        }
                        list.addAll(StonecutterRecipeMaker.makeRecipes("exchange", family));
                    }
                    return list == null ? List.of() : list;
                });
            }
        }
        catch (ExecutionException families) {
            // empty catch block
        }
        List sourceRecipes = List.of();
        try {
            Collection<KHolder<BlockFamily>> families = BlockFamilies.findByStonecutterSource(item);
            if (!families.isEmpty()) {
                sourceRecipes = (List)SOURCE_CACHE.get((Object)item, () -> {
                    ArrayList list = Lists.newArrayList();
                    for (KHolder family : families) {
                        list.addAll(StonecutterRecipeMaker.makeRecipes("to", family));
                    }
                    return list;
                });
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (exchangeRecipes.isEmpty() && sourceRecipes.isEmpty()) {
            return recipes;
        }
        return Streams.concat((Stream[])new Stream[]{recipes.stream(), exchangeRecipes.stream(), sourceRecipes.stream()}).map(r -> r).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<RecipeHolder<StonecutterRecipe>> makeRecipes(String type, KHolder<BlockFamily> family) {
        Ingredient input = switch (type) {
            case "exchange" -> family.value().ingredient();
            case "exchange_in_viewer" -> family.value().ingredientInViewer();
            case "to" -> family.value().stonecutterSourceIngredient();
            default -> throw new IllegalArgumentException();
        };
        ResourceLocation prefix = family.key().withPath("fake/stonecutter/%s/%s".formatted(family.key().getPath(), "exchange_in_viewer".equals(type) ? "exchange" : type));
        return family.value().items().map(item -> {
            int count;
            if ("to".equals(type)) {
                count = ((BlockFamily)family.value()).stonecutterSourceMultiplier();
            } else {
                count = Mth.floor((float)(1.0f / BlockFamilies.getConvertRatio(item)));
                if (count < 1) {
                    return null;
                }
            }
            ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey(item);
            ResourceLocation recipeId = prefix.withSuffix("/%s/%s".formatted(itemKey.getNamespace(), itemKey.getPath()));
            StonecutterRecipe recipe = new StonecutterRecipe(prefix.toString(), input, new ItemStack((ItemLike)item, count));
            return new RecipeHolder(recipeId, (Recipe)recipe);
        }).filter(Objects::nonNull).toList();
    }

    public static void invalidateCache() {
        EXCHANGE_CACHE.invalidateAll();
        SOURCE_CACHE.invalidateAll();
    }
}

