/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.family;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.block.family.BlockFamilyInferrer;
import snownee.kiwi.customization.block.family.StonecutterRecipeMaker;
import snownee.kiwi.util.KHolder;
import snownee.kiwi.util.resource.OneTimeLoader;

public class BlockFamilies {
    private static ImmutableListMultimap<Item, KHolder<BlockFamily>> byItem = ImmutableListMultimap.of();
    private static ImmutableList<KHolder<BlockFamily>> fromResources = ImmutableList.of();
    private static ImmutableMap<ResourceLocation, KHolder<BlockFamily>> byId = ImmutableMap.of();
    private static ImmutableListMultimap<Item, KHolder<BlockFamily>> byStonecutterSource = ImmutableListMultimap.of();

    public static Collection<KHolder<BlockFamily>> find(Item item) {
        if (item == Items.AIR) {
            return List.of();
        }
        return byItem.get((Object)item);
    }

    public static List<KHolder<BlockFamily>> findQuickSwitch(Item item, boolean creative) {
        Stream<KHolder<BlockFamily>> stream = BlockFamilies.find(item).stream();
        stream = creative ? stream.filter(f -> ((BlockFamily)f.value()).switchAttrs().enabled()) : stream.filter(f -> ((BlockFamily)f.value()).switchAttrs().enabled() && !((BlockFamily)f.value()).switchAttrs().creativeOnly());
        return stream.toList();
    }

    public static Collection<KHolder<BlockFamily>> findByStonecutterSource(Item item) {
        return byStonecutterSource.get((Object)item);
    }

    public static void reloadResources(ResourceManager resourceManager, OneTimeLoader.Context context) {
        Map<ResourceLocation, BlockFamily> families = OneTimeLoader.load(resourceManager, "kiwi/family", BlockFamily.CODEC, context);
        fromResources = (ImmutableList)families.entrySet().stream().map(e -> new KHolder<BlockFamily>((ResourceLocation)e.getKey(), (BlockFamily)e.getValue())).collect(ImmutableList.toImmutableList());
    }

    public static int reloadTags() {
        BlockFamilies.reloadComplete(List.of());
        if (CustomizationHooks.kswitch) {
            BlockFamilies.reloadComplete(new BlockFamilyInferrer().generate());
        }
        return byId.size();
    }

    private static void reloadComplete(Collection<KHolder<BlockFamily>> additional) {
        HashMap byIdBuilder = Maps.newHashMapWithExpectedSize((int)(fromResources.size() + additional.size()));
        ImmutableListMultimap.Builder byItemBuilder = ImmutableListMultimap.builder();
        ImmutableListMultimap.Builder byStonecutterBuilder = ImmutableListMultimap.builder();
        for (KHolder family : Iterables.concat(fromResources, additional)) {
            KHolder old = byIdBuilder.putIfAbsent(family.key(), family);
            if (old != null) {
                Kiwi.LOGGER.error("Duplicate family {}", (Object)family);
                continue;
            }
            for (Holder.Reference<Item> item : ((BlockFamily)family.value()).itemHolders()) {
                byItemBuilder.put((Object)((Item)item.value()), (Object)family);
            }
            Optional<Holder.Reference<Item>> stonecutterSource = ((BlockFamily)family.value()).stonecutterSource();
            if (!stonecutterSource.isPresent()) continue;
            byStonecutterBuilder.put((Object)((Item)stonecutterSource.get().value()), (Object)family);
        }
        byId = ImmutableMap.copyOf((Map)byIdBuilder);
        byItem = byItemBuilder.build();
        byStonecutterSource = byStonecutterBuilder.build();
        StonecutterRecipeMaker.invalidateCache();
    }

    public static BlockFamily get(ResourceLocation id) {
        KHolder holder = (KHolder)byId.get((Object)id);
        return holder == null ? null : (BlockFamily)holder.value();
    }

    public static Collection<KHolder<BlockFamily>> all() {
        return byId.values();
    }

    public static float getConvertRatio(Item item) {
        Block block = Block.byItem((Item)item);
        if (block == Blocks.AIR) {
            return 1.0f;
        }
        Holder holder = BuiltInRegistries.BLOCK.wrapAsHolder((Object)block);
        if (holder.is(BlockTags.SLABS)) {
            return 0.5f;
        }
        if (holder.is(BlockTags.DOORS)) {
            return 2.0f;
        }
        if (holder.is(BlockTags.TRAPDOORS)) {
            return 3.0f;
        }
        if (holder.is(BlockTags.FENCE_GATES)) {
            return 4.0f;
        }
        if (holder.is(BlockTags.PRESSURE_PLATES)) {
            return 2.0f;
        }
        return 1.0f;
    }
}

