/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.component.LayeredComponent;
import snownee.kiwi.customization.block.loader.KBlockComponents;

public record StackableComponent(IntegerProperty property) implements KBlockComponent,
LayeredComponent
{
    public static final MapCodec<StackableComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.intRange((int)0, (int)1).optionalFieldOf("min", (Object)1).forGetter(StackableComponent::minValue), (App)ExtraCodecs.POSITIVE_INT.fieldOf("max").forGetter(StackableComponent::maxValue)).apply((Applicative)instance, StackableComponent::create));

    public static StackableComponent create(int max) {
        return StackableComponent.create(1, max);
    }

    public static StackableComponent create(int min, int max) {
        return new StackableComponent(KBlockUtils.internProperty(IntegerProperty.create((String)"c", (int)min, (int)max)));
    }

    @Override
    public KBlockComponent.Type<?> type() {
        return KBlockComponents.STACKABLE.getOrCreate();
    }

    @Override
    public void injectProperties(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.property});
    }

    @Override
    public BlockState registerDefaultState(BlockState state) {
        return (BlockState)state.setValue((Property)this.property, (Comparable)Integer.valueOf(this.getDefaultLayer()));
    }

    public int minValue() {
        return this.property.min;
    }

    public int maxValue() {
        return this.property.max;
    }

    @Override
    public boolean hasAnalogOutputSignal() {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(BlockState state) {
        return Math.min((Integer)state.getValue((Property)this.property) - this.minValue() + 1, 15);
    }

    @Override
    public BlockState getStateForPlacement(KBlockSettings settings, BlockState state, BlockPlaceContext context) {
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        if (blockState.is(state.getBlock())) {
            return (BlockState)blockState.setValue((Property)this.property, (Comparable)Integer.valueOf(Math.min(this.maxValue(), (Integer)blockState.getValue((Property)this.property) + 1)));
        }
        return state;
    }

    @Override
    @Nullable
    public Boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        if (!context.isSecondaryUseActive() && context.getItemInHand().is(state.getBlock().asItem()) && (Integer)state.getValue((Property)this.property) < this.maxValue()) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public IntegerProperty getLayerProperty() {
        return this.property;
    }

    @Override
    public int getDefaultLayer() {
        return this.minValue();
    }
}

