/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.loader.KBlockComponents;

public record HorizontalComponent(boolean oppose) implements KBlockComponent
{
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final HorizontalComponent NORMAL = new HorizontalComponent(false);
    private static final HorizontalComponent OPPOSE = new HorizontalComponent(true);
    public static final MapCodec<HorizontalComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("oppose", (Object)false).forGetter(HorizontalComponent::oppose)).apply((Applicative)instance, HorizontalComponent::getInstance));

    public static HorizontalComponent getInstance(boolean oppose) {
        return oppose ? OPPOSE : NORMAL;
    }

    @Override
    public KBlockComponent.Type<?> type() {
        return KBlockComponents.HORIZONTAL.getOrCreate();
    }

    @Override
    public void injectProperties(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Override
    public BlockState registerDefaultState(BlockState state) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.NORTH);
    }

    @Override
    public BlockState getStateForPlacement(KBlockSettings settings, BlockState state, BlockPlaceContext context) {
        if (settings.customPlacement) {
            return state;
        }
        Direction firstDirection = context.getHorizontalDirection();
        Iterable directions = Iterables.concat(List.of(firstDirection), List.of(context.getNearestLookingDirections()));
        int index = 0;
        for (Direction direction : directions) {
            BlockState blockstate;
            if (direction.getAxis().isVertical() || ++index > 1 && direction == firstDirection || !(blockstate = (BlockState)state.setValue((Property)FACING, (Comparable)(this.oppose ? direction : direction.getOpposite()))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return blockstate;
        }
        return null;
    }

    @Override
    public Direction getHorizontalFacing(BlockState blockState) {
        Direction direction = (Direction)blockState.getValue((Property)FACING);
        return this.oppose ? direction.getOpposite() : direction;
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }
}

