/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.GlassType;
import snownee.kiwi.customization.block.behavior.CanSurviveHandler;
import snownee.kiwi.customization.block.component.DirectionalComponent;
import snownee.kiwi.customization.block.component.HorizontalComponent;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.component.WaterLoggableComponent;
import snownee.kiwi.customization.duck.KBlockProperties;
import snownee.kiwi.customization.placement.PlaceChoices;
import snownee.kiwi.customization.shape.BlockShapeType;
import snownee.kiwi.customization.shape.ConfiguringShape;
import snownee.kiwi.customization.shape.ShapeGenerator;

public class KBlockSettings {
    public final boolean customPlacement;
    public final GlassType glassType;
    @Nullable
    public final CanSurviveHandler canSurviveHandler;
    @Nullable
    public final ToIntFunction<BlockState> analogOutputSignal;
    public final Map<KBlockComponent.Type<?>, KBlockComponent> components;
    @Nullable
    private ShapeGenerator[] shapes;
    public PlaceChoices placeChoices;

    private KBlockSettings(Builder builder) {
        this.customPlacement = builder.customPlacement;
        this.glassType = builder.glassType;
        this.canSurviveHandler = builder.canSurviveHandler;
        this.analogOutputSignal = builder.getAnalogOutputSignal();
        this.components = Map.copyOf(builder.components);
        for (BlockShapeType type : BlockShapeType.VALUES) {
            this.setShape(type, builder.getShape(type));
        }
    }

    public static KBlockSettings empty() {
        return new KBlockSettings(KBlockSettings.builder());
    }

    public static Builder builder() {
        return new Builder(BlockBehaviour.Properties.of());
    }

    public static Builder copyProperties(Block block) {
        return new Builder(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block));
    }

    public static Builder copyProperties(Block block, MapColor mapColor) {
        return new Builder(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block).mapColor(mapColor));
    }

    public static KBlockSettings of(Object block) {
        return ((KBlockProperties)((BlockBehaviour)block).properties()).kiwi$getSettings();
    }

    public static VoxelShape getGlassFaceShape(BlockState blockState, Direction direction) {
        KBlockSettings settings = KBlockSettings.of(blockState.getBlock());
        if (settings == null) {
            VoxelShape shape = blockState.getShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, CollisionContext.empty());
            return Block.isShapeFullBlock((VoxelShape)shape) ? Shapes.block() : Shapes.empty();
        }
        if (settings.glassType == null) {
            return Shapes.empty();
        }
        VoxelShape shape = blockState.getShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, CollisionContext.empty());
        if (shape.isEmpty()) {
            return Shapes.empty();
        }
        return Shapes.getFaceShape((VoxelShape)shape, (Direction)direction);
    }

    public boolean hasComponent(KBlockComponent.Type<?> type) {
        return this.components.containsKey(type);
    }

    public <T extends KBlockComponent> T getComponent(KBlockComponent.Type<T> type) {
        return (T)this.components.get(type);
    }

    public void injectProperties(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        for (KBlockComponent component : this.components.values()) {
            component.injectProperties(block, builder);
        }
    }

    public BlockState registerDefaultState(BlockState state) {
        for (KBlockComponent component : this.components.values()) {
            state = component.registerDefaultState(state);
        }
        return state;
    }

    public BlockState getStateForPlacement(BlockState blockState, BlockPlaceContext context) {
        for (KBlockComponent component : this.components.values()) {
            blockState = component.getStateForPlacement(this, blockState, context);
            if (blockState != null && blockState.is(blockState.getBlock())) continue;
            return blockState;
        }
        if (!(this.placeChoices == null || this.placeChoices.skippable() && context.isSecondaryUseActive())) {
            blockState = this.placeChoices.getStateForPlacement(context.getLevel(), context.getClickedPos(), blockState);
        }
        return blockState;
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        for (KBlockComponent component : this.components.values()) {
            pState = component.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
        }
        return pState;
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        for (KBlockComponent component : this.components.values()) {
            pState = component.rotate(pState, pRotation);
        }
        return pState;
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        for (KBlockComponent component : this.components.values()) {
            pState = component.mirror(pState, pMirror);
        }
        return pState;
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        for (KBlockComponent component : this.components.values()) {
            if (!component.useShapeForLightOcclusion(pState)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        for (KBlockComponent component : this.components.values()) {
            Boolean result = component.canBeReplaced(state, context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public ConfiguringShape removeIfPossible(BlockShapeType shapeType) {
        ShapeGenerator shapeGenerator = this.getShape(shapeType);
        if (shapeGenerator instanceof ConfiguringShape) {
            ConfiguringShape shape = (ConfiguringShape)shapeGenerator;
            this.setShape(shapeType, null);
            return shape;
        }
        return null;
    }

    public ShapeGenerator getShape(BlockShapeType shapeType) {
        return this.shapes != null ? this.shapes[shapeType.ordinal()] : null;
    }

    private void setShape(BlockShapeType shapeType, @Nullable ShapeGenerator shape) {
        if (shape != null) {
            if (this.shapes == null) {
                this.shapes = new ShapeGenerator[BlockShapeType.VALUES.size()];
            }
            this.shapes[shapeType.ordinal()] = shape;
        } else if (this.shapes != null) {
            this.shapes[shapeType.ordinal()] = null;
        }
    }

    public static class Builder {
        private final BlockBehaviour.Properties properties;
        private boolean customPlacement;
        @Nullable
        private GlassType glassType;
        private final ShapeGenerator[] shapes = new ShapeGenerator[BlockShapeType.VALUES.size()];
        @Nullable
        private CanSurviveHandler canSurviveHandler;
        private final Map<KBlockComponent.Type<?>, KBlockComponent> components = Maps.newLinkedHashMap();
        @Nullable
        private ToIntFunction<BlockState> analogOutputSignal;

        private Builder(BlockBehaviour.Properties properties) {
            this.properties = properties;
        }

        public BlockBehaviour.Properties get() {
            KBlockSettings settings = new KBlockSettings(this);
            ((KBlockProperties)this.properties).kiwi$setSettings(settings);
            return this.properties;
        }

        public Builder configure(Consumer<BlockBehaviour.Properties> configurator) {
            configurator.accept(this.properties);
            return this;
        }

        public Builder noOcclusion() {
            this.properties.noOcclusion();
            return this;
        }

        public Builder noCollision() {
            this.properties.noCollission();
            return this;
        }

        public Builder customPlacement() {
            this.customPlacement = true;
            return this;
        }

        public Builder glassType(GlassType glassType) {
            this.glassType = glassType;
            return this;
        }

        public Builder shape(BlockShapeType type, ShapeGenerator shape) {
            this.shapes[type.ordinal()] = shape;
            return this;
        }

        @Nullable
        private ShapeGenerator getShape(BlockShapeType type) {
            return this.shapes[type.ordinal()];
        }

        public Builder canSurviveHandler(CanSurviveHandler canSurviveHandler) {
            this.canSurviveHandler = canSurviveHandler;
            return this;
        }

        public Builder component(KBlockComponent component) {
            KBlockComponent before = this.components.put(component.type(), component);
            Preconditions.checkState((before == null ? 1 : 0) != 0, (String)"Component %s is already present", component.type());
            return this;
        }

        public Builder waterLoggable() {
            return this.component(WaterLoggableComponent.getInstance());
        }

        public Builder horizontal() {
            return this.component(HorizontalComponent.getInstance(false));
        }

        public Builder directional() {
            return this.component(DirectionalComponent.getInstance(false));
        }

        public boolean hasComponent(KBlockComponent.Type<?> type) {
            return this.components.containsKey(type);
        }

        public Builder removeComponent(KBlockComponent.Type<?> type) {
            this.components.remove(type);
            return this;
        }

        @Nullable
        public ToIntFunction<BlockState> getAnalogOutputSignal() {
            if (this.analogOutputSignal != null) {
                return this.analogOutputSignal;
            }
            for (KBlockComponent component : this.components.values()) {
                if (!component.hasAnalogOutputSignal()) continue;
                return component::getAnalogOutputSignal;
            }
            return null;
        }
    }

    @Deprecated
    public record MoreInfo(ResourceLocation shape, ResourceLocation collisionShape, ResourceLocation interactionShape) {
    }
}

