/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import snownee.kiwi.util.KUtil;
import snownee.kiwi.util.resource.AlternativesFileToIdConverter;
import snownee.kiwi.util.resource.OneTimeLoader;

public record CustomizationMetadata(ImmutableListMultimap<String, String> registryOrder, List<String> lenientBETypeNamespaces) {
    public static final Codec<CustomizationMetadata> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()).fieldOf("registry_order").forGetter($ -> {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : $.registryOrder().asMap().entrySet()) {
            map.put((String)entry.getKey(), List.copyOf((Collection)entry.getValue()));
        }
        return map;
    }), (App)Codec.STRING.listOf().optionalFieldOf("lenient_be_type_namespaces", List.of()).forGetter(CustomizationMetadata::lenientBETypeNamespaces)).apply((Applicative)instance, CustomizationMetadata::create));

    public static CustomizationMetadata create(Map<String, List<String>> map, List<String> lenientBETypeNamespaces) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        map.forEach((arg_0, arg_1) -> ((ImmutableListMultimap.Builder)builder).putAll(arg_0, arg_1));
        return new CustomizationMetadata((ImmutableListMultimap<String, String>)builder.build(), lenientBETypeNamespaces);
    }

    public static Map<String, CustomizationMetadata> loadMap(ResourceManager resourceManager, OneTimeLoader.Context context) {
        CustomizationMetadata emptyMetadata = new CustomizationMetadata((ImmutableListMultimap<String, String>)ImmutableListMultimap.of(), List.of());
        AlternativesFileToIdConverter fileToIdConverter = AlternativesFileToIdConverter.yamlOrJson("kiwi");
        HashMap metadataMap = Maps.newHashMap();
        for (String namespace : resourceManager.getNamespaces()) {
            ResourceLocation file = fileToIdConverter.idToFile(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"metadata"));
            Optional resource = resourceManager.getResource(file);
            if (resource.isEmpty()) {
                metadataMap.put(namespace, emptyMetadata);
                continue;
            }
            DataResult<CustomizationMetadata> result = OneTimeLoader.parseFile(file, (Resource)resource.get(), CODEC, context);
            if (result == null) {
                context.addDisabledNamespace(namespace);
                continue;
            }
            result.result().ifPresentOrElse(customizationMetadata -> metadataMap.put(namespace, customizationMetadata), () -> context.addDisabledNamespace(namespace));
        }
        return metadataMap;
    }

    public static <T> void sortedForEach(Map<String, CustomizationMetadata> metadataMap, String key, Map<ResourceLocation, T> values, BiConsumer<ResourceLocation, T> action) {
        LinkedHashSet order = Sets.newLinkedHashSet();
        metadataMap.forEach((namespace, metadata) -> {
            for (String s : metadata.registryOrder().get((Object)key)) {
                order.add(KUtil.RL(s, namespace));
            }
        });
        for (ResourceLocation id2 : order) {
            T value2 = values.get(id2);
            if (value2 == null) continue;
            action.accept(id2, (ResourceLocation)value2);
        }
        values.forEach((id, value) -> {
            if (!order.contains(id)) {
                action.accept((ResourceLocation)id, (ResourceLocation)value);
            }
        });
    }
}

