/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.loading.ClientModLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.RegistryBuilder;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.CustomizationClient;
import snownee.kiwi.customization.CustomizationMetadata;
import snownee.kiwi.customization.CustomizationRegistries;
import snownee.kiwi.customization.CustomizationServiceFinder;
import snownee.kiwi.customization.KiwiPackResourceManager;
import snownee.kiwi.customization.block.BlockFundamentals;
import snownee.kiwi.customization.block.GlassType;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.behavior.BlockBehaviorRegistry;
import snownee.kiwi.customization.block.behavior.SitManager;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.loader.KBlockDefinition;
import snownee.kiwi.customization.block.loader.KBlockTemplate;
import snownee.kiwi.customization.builder.BuilderRules;
import snownee.kiwi.customization.item.ItemFundamentals;
import snownee.kiwi.customization.item.loader.KCreativeTab;
import snownee.kiwi.customization.item.loader.KItemTemplate;
import snownee.kiwi.customization.placement.PlacementSystem;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.ClientProxy;
import snownee.kiwi.util.resource.OneTimeLoader;
import snownee.kiwi.util.resource.RequiredFolderRepositorySource;

@Mod(value="kiwi")
public final class CustomizationHooks {
    private static final Set<String> blockNamespaces = Sets.newLinkedHashSet();
    private static final Set<String> lenientBETypeNamespaces = Sets.newHashSet();
    private static boolean enabled = true;
    public static boolean kswitch = Platform.isModLoaded("kswitch") || !Platform.isProduction();
    @Nullable
    private static GlassType clearGlassType;
    private static final int CACHE_SIZE = 512;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>> OCCLUSION_CACHE;

    private CustomizationHooks() {
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean skipGlassRendering(BlockState pState, BlockState pAdjacentBlockState, Direction pDirection) {
        if (KBlockSettings.of(pState.getBlock()) == null && KBlockSettings.of(pAdjacentBlockState.getBlock()) == null) {
            return false;
        }
        GlassType glassType = CustomizationHooks.getGlassType(pState);
        if (glassType == null || !glassType.skipRendering()) {
            return false;
        }
        if (!pState.is(pAdjacentBlockState.getBlock()) && glassType != CustomizationHooks.getGlassType(pAdjacentBlockState)) {
            return false;
        }
        Block.BlockStatePairKey key = new Block.BlockStatePairKey(pState, pAdjacentBlockState, pDirection);
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> map = OCCLUSION_CACHE.get();
        byte b0 = map.getAndMoveToFirst((Object)key);
        if (b0 != 127) {
            return b0 == 0;
        }
        VoxelShape shape1 = KBlockSettings.getGlassFaceShape(pState, pDirection);
        if (shape1.isEmpty()) {
            return true;
        }
        VoxelShape shape2 = KBlockSettings.getGlassFaceShape(pAdjacentBlockState, pDirection.getOpposite());
        boolean flag = Shapes.joinIsNotEmpty((VoxelShape)shape1, (VoxelShape)shape2, (BooleanOp)BooleanOp.ONLY_FIRST);
        if (map.size() == 512) {
            map.removeLastByte();
        }
        map.putAndMoveToFirst((Object)key, (byte)(flag ? 1 : 0));
        return !flag;
    }

    @Nullable
    public static GlassType getGlassType(BlockState blockState) {
        KBlockSettings settings = KBlockSettings.of(blockState.getBlock());
        if (settings != null && settings.glassType != null) {
            return settings.glassType;
        }
        if (CustomizationHooks.isColorlessGlass(blockState)) {
            return clearGlassType;
        }
        return null;
    }

    public CustomizationHooks(IEventBus modEventBus) {
        enabled = CustomizationServiceFinder.shouldEnable(ModList.get().getMods());
        if (!CustomizationHooks.isEnabled()) {
            return;
        }
        Kiwi.LOGGER.info("Kiwi Customization is enabled");
        IEventBus forgeEventBus = NeoForge.EVENT_BUS;
        modEventBus.addListener(EventPriority.LOWEST, event -> {
            if (!Registries.BLOCK.equals(event.getRegistryKey())) {
                return;
            }
            CustomizationHooks.initLoader(modEventBus);
        });
        modEventBus.addListener(event -> {
            CustomizationRegistries.BLOCK_COMPONENT = event.create(new RegistryBuilder(CustomizationRegistries.BLOCK_COMPONENT_KEY));
            Kiwi.registerRegistry(CustomizationRegistries.BLOCK_COMPONENT_KEY, KBlockComponent.Type.class);
            CustomizationRegistries.BLOCK_TEMPLATE = event.create(new RegistryBuilder(CustomizationRegistries.BLOCK_TEMPLATE_KEY));
            Kiwi.registerRegistry(CustomizationRegistries.BLOCK_TEMPLATE_KEY, KBlockTemplate.Type.class);
            CustomizationRegistries.ITEM_TEMPLATE = event.create(new RegistryBuilder(CustomizationRegistries.ITEM_TEMPLATE_KEY));
            Kiwi.registerRegistry(CustomizationRegistries.ITEM_TEMPLATE_KEY, KItemTemplate.Type.class);
        });
        modEventBus.addListener(event -> event.addRepositorySource((RepositorySource)new RequiredFolderRepositorySource(CustomizationServiceFinder.PACK_DIRECTORY, event.getPackType(), PackSource.BUILT_IN, new DirectoryValidator($ -> true))));
        forgeEventBus.addListener(event -> {
            if (PlacementSystem.isDebugEnabled(event.getPlayer())) {
                PlacementSystem.removeDebugBlocks(event.getPlayer().level(), event.getPos());
            }
        });
        forgeEventBus.addListener(event -> {
            InteractionResult result = BlockBehaviorRegistry.getInstance().onUseBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
            if (result.consumesAction()) {
                event.setCanceled(true);
                event.setCancellationResult(result);
            }
        });
        forgeEventBus.addListener(event -> {
            if (event.getHand() == InteractionHand.MAIN_HAND && SitManager.sit(event.getEntity(), event.getHitVec())) {
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getLevel().isClientSide));
                event.setCanceled(true);
            }
        });
        forgeEventBus.addListener(event -> BlockFamilies.reloadTags());
        if (Platform.isPhysicalClient()) {
            CustomizationClient.init(modEventBus);
        }
    }

    public static void initLoader(IEventBus modEventBus) {
        ResourceManager resourceManager = CustomizationHooks.collectKiwiPacks();
        OneTimeLoader.Context context = new OneTimeLoader.Context();
        Map<String, CustomizationMetadata> metadataMap = CustomizationMetadata.loadMap(resourceManager, context);
        BlockFundamentals blockFundamentals = BlockFundamentals.reload(resourceManager, context, true);
        clearGlassType = blockFundamentals.glassTypes().get(ResourceLocation.withDefaultNamespace((String)"clear"));
        Preconditions.checkNotNull((Object)clearGlassType, (Object)"Missing 'clear' glass type");
        blockNamespaces.clear();
        blockFundamentals.blocks().keySet().stream().map(ResourceLocation::getNamespace).forEach(blockNamespaces::add);
        lenientBETypeNamespaces.clear();
        lenientBETypeNamespaces.add("minecraft");
        lenientBETypeNamespaces.addAll(blockNamespaces);
        metadataMap.values().forEach(metadata -> lenientBETypeNamespaces.addAll(metadata.lenientBETypeNamespaces()));
        ArrayList blockIds = Lists.newArrayList();
        CustomizationMetadata.sortedForEach(metadataMap, "block", blockFundamentals.blocks(), (id, definition) -> {
            try {
                Block block = definition.createBlock((ResourceLocation)id, blockFundamentals.shapes());
                if (block == null) {
                    return;
                }
                Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)id, (Object)block);
                blockFundamentals.slotProviders().attachSlotsA(block, (KBlockDefinition)definition);
                blockFundamentals.placeChoices().attachChoicesA(block, (KBlockDefinition)definition);
                blockIds.add(id);
            }
            catch (Exception e) {
                Kiwi.LOGGER.error("Failed to create block %s".formatted(id), (Throwable)e);
            }
        });
        ItemFundamentals itemFundamentals = ItemFundamentals.reload(resourceManager, context, true);
        for (ResourceLocation blockId : blockIds) {
            if (itemFundamentals.items().containsKey(blockId)) continue;
            itemFundamentals.addDefaultBlockItem(blockId);
        }
        KItemTemplate none = itemFundamentals.templates().get(ResourceLocation.withDefaultNamespace((String)"none"));
        Preconditions.checkNotNull((Object)none, (Object)"Missing 'none' item definition");
        CustomizationMetadata.sortedForEach(metadataMap, "item", itemFundamentals.items(), (id, definition) -> {
            try {
                if (definition.template().template() == none) {
                    return;
                }
                Item item = definition.createItem((ResourceLocation)id);
                if (item == null) {
                    return;
                }
                Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)id, (Object)item);
            }
            catch (Exception e) {
                Kiwi.LOGGER.error("Failed to create item %s".formatted(id), (Throwable)e);
            }
        });
        blockFundamentals.slotProviders().attachSlotsB();
        blockFundamentals.placeChoices().attachChoicesB();
        blockFundamentals.slotLinks().finish();
        if (Platform.isPhysicalClient()) {
            CustomizationClient.afterRegister(itemFundamentals.items(), blockFundamentals.blocks(), new ClientProxy.Context(ClientModLoader.isLoading(), modEventBus));
        }
        Map<ResourceLocation, KCreativeTab> tabs = OneTimeLoader.load(resourceManager, "kiwi/creative_tab", KCreativeTab.CODEC, context);
        List<Map.Entry> newTabs = tabs.entrySet().stream().sorted(Comparator.comparingInt($ -> ((KCreativeTab)$.getValue()).order())).filter(entry -> {
            KCreativeTab value = (KCreativeTab)entry.getValue();
            if (value.insert().isPresent()) {
                CustomizationHooks.insertToTab(modEventBus, value);
                return false;
            }
            return true;
        }).toList();
        for (int i = 0; i < newTabs.size(); ++i) {
            Map.Entry entry2 = newTabs.get(i);
            ResourceLocation key = (ResourceLocation)entry2.getKey();
            KCreativeTab value = (KCreativeTab)entry2.getValue();
            CreativeModeTab.Builder tab = AbstractModule.itemCategory(key, () -> BuiltInRegistries.ITEM.getOptional(value.icon()).orElse(Items.BARRIER).getDefaultInstance()).displayItems((params, output) -> output.acceptAll(value.contents().stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).filter(Objects::nonNull).map(Item::getDefaultInstance).toList()));
            if (i > 0) {
                tab.withTabsBefore(new ResourceLocation[]{(ResourceLocation)newTabs.get(i - 1).getKey()});
            }
            if (i < newTabs.size() - 1) {
                tab.withTabsAfter(new ResourceLocation[]{(ResourceLocation)newTabs.get(i + 1).getKey()});
            }
            Registry.register((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, (ResourceLocation)key, (Object)tab.build());
        }
        BlockFamilies.reloadResources(resourceManager, context);
        if (!Platform.isDataGen()) {
            BuilderRules.reload(resourceManager, context);
        }
    }

    private static void insertToTab(IEventBus modEventBus, KCreativeTab kCreativeTab) {
        if (!Platform.isPhysicalClient()) {
            return;
        }
        modEventBus.addListener(event -> {
            if (event.getTabKey() != kCreativeTab.insert().orElseThrow()) {
                return;
            }
            for (ResourceKey<Item> content : kCreativeTab.contents()) {
                Item item = (Item)BuiltInRegistries.ITEM.get(content);
                if (item == null) {
                    return;
                }
                event.accept((ItemLike)item);
            }
        });
    }

    public static ResourceManager collectKiwiPacks() {
        CustomizationServiceFinder.PACK_DIRECTORY.toFile().mkdirs();
        RequiredFolderRepositorySource folderRepositorySource = new RequiredFolderRepositorySource(CustomizationServiceFinder.PACK_DIRECTORY, PackType.CLIENT_RESOURCES, PackSource.BUILT_IN, new DirectoryValidator($ -> true));
        PackRepository packRepository = new PackRepository(new RepositorySource[]{folderRepositorySource});
        HashMap<IModFile, Pack.ResourcesSupplier> kiwiPacks = new HashMap<IModFile, Pack.ResourcesSupplier>();
        block0: for (IModFileInfo modFileInfo : ModList.get().getModFiles()) {
            for (IModInfo modInfo : modFileInfo.getMods()) {
                if (!modInfo.getModProperties().containsKey("kiwiCustomization")) continue;
                Pack.ResourcesSupplier modResourcePack = ResourcePackLoader.createPackForMod((IModFileInfo)modFileInfo);
                kiwiPacks.put(modFileInfo.getFile(), modResourcePack);
                continue block0;
            }
        }
        packRepository.addPackFinder(ResourcePackLoader.buildPackFinder(kiwiPacks, (PackType)PackType.SERVER_DATA));
        packRepository.reload();
        ArrayList selected = Lists.newArrayList((Iterable)packRepository.getAvailableIds());
        packRepository.setSelected((Collection)selected);
        return new KiwiPackResourceManager(packRepository.openAllSelected());
    }

    public static Set<String> getBlockNamespaces() {
        return blockNamespaces;
    }

    public static Set<String> getLenientBETypeNamespaces() {
        return lenientBETypeNamespaces;
    }

    public static boolean isColorlessGlass(BlockState blockState) {
        return blockState.is(Tags.Blocks.GLASS_BLOCKS_COLORLESS);
    }

    public static GlassType clearGlassType() {
        return clearGlassType;
    }

    static {
        OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
            Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>(512, 0.25f){

                protected void rehash(int needed) {
                }
            };
            object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
            return object2bytelinkedopenhashmap;
        });
    }
}

