/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.ModContext;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.contributor.Contributors;
import snownee.kiwi.contributor.client.CosmeticLayer;
import snownee.kiwi.contributor.client.gui.CosmeticScreen;
import snownee.kiwi.contributor.network.CSetCosmeticPacket;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.network.KPacketSender;
import snownee.kiwi.util.KUtil;

public class ContributorsClient
extends AbstractModule {
    private static int hold;

    @Override
    protected void init(InitEvent event) {
        event.enqueueWork(() -> {
            IEventBus eventBus = Objects.requireNonNull(ModContext.get((String)"kiwi").modContainer.getEventBus());
            eventBus.addListener(e -> {
                for (PlayerSkin.Model skin : e.getSkins()) {
                    EntityRenderer patt0$temp = e.getSkin(skin);
                    if (!(patt0$temp instanceof PlayerRenderer)) continue;
                    PlayerRenderer renderer = (PlayerRenderer)patt0$temp;
                    CosmeticLayer layer = new CosmeticLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer);
                    CosmeticLayer.ALL_LAYERS.add(layer);
                    renderer.addLayer((RenderLayer)layer);
                }
            });
            NeoForge.EVENT_BUS.addListener(e -> ContributorsClient.changeCosmetic());
            NeoForge.EVENT_BUS.addListener(e -> {
                Contributors.PLAYER_COSMETICS.clear();
                CosmeticLayer.ALL_LAYERS.forEach(l -> l.getCache().invalidateAll());
            });
            NeoForge.EVENT_BUS.addListener(e -> ContributorsClient.onKeyInput(Minecraft.getInstance()));
        });
    }

    public static void onKeyInput(Minecraft mc) {
        if (!KiwiClientConfig.cosmeticScreenKeybind || mc.screen != null || mc.player == null || !mc.isWindowActive()) {
            return;
        }
        boolean K = InputConstants.isKeyDown((long)mc.getWindow().getWindow(), (int)75);
        if (!K || Screen.hasAltDown() || Screen.hasControlDown() || Screen.hasShiftDown()) {
            hold = 0;
            return;
        }
        if (++hold == 30) {
            CosmeticScreen screen = new CosmeticScreen();
            mc.setScreen((Screen)screen);
        }
    }

    public static void changeCosmetic() {
        ResourceLocation id = KUtil.RL(KiwiClientConfig.contributorCosmetic);
        if (id != null && id.getPath().isEmpty()) {
            id = null;
        }
        ResourceLocation cosmetic = id;
        Contributors.canPlayerUseCosmetic(ContributorsClient.getPlayerName(), cosmetic).thenAccept(bl -> {
            if (!bl.booleanValue()) {
                ConfigHandler cfg = KiwiConfigManager.getHandler(KiwiClientConfig.class);
                KiwiClientConfig.contributorCosmetic = "";
                cfg.save();
                return;
            }
            KPacketSender.sendToServer(new CSetCosmeticPacket(cosmetic));
            if (cosmetic == null) {
                Contributors.PLAYER_COSMETICS.remove(ContributorsClient.getPlayerName());
            } else {
                Contributors.PLAYER_COSMETICS.put(ContributorsClient.getPlayerName(), cosmetic);
                Kiwi.LOGGER.info("Enabled contributor effect: {}", (Object)cosmetic);
            }
            CosmeticLayer.ALL_LAYERS.forEach(l -> l.getCache().invalidate((Object)ContributorsClient.getPlayerName()));
        });
    }

    public static void changeCosmetic(Map<String, ResourceLocation> changes) {
        changes.forEach((k, v) -> {
            if (v == null) {
                Contributors.PLAYER_COSMETICS.remove(k);
            } else {
                Contributors.PLAYER_COSMETICS.put((String)k, (ResourceLocation)v);
            }
        });
        CosmeticLayer.ALL_LAYERS.forEach(l -> l.getCache().invalidateAll(changes.keySet()));
    }

    private static String getPlayerName() {
        return Minecraft.getInstance().getUser().getName();
    }
}

