/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.GroupSetting;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiGOHolder;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.ModContext;
import snownee.kiwi.RegistryLookup;
import snownee.kiwi.block.IKiwiBlock;
import snownee.kiwi.item.ItemCategoryFiller;
import snownee.kiwi.item.ModBlockItem;
import snownee.kiwi.loader.ClientPlatform;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.util.KUtil;

public final class KiwiModuleContainer {
    public final AbstractModule module;
    public final ModContext context;
    public GroupSetting groupSetting;
    final RegistryEntryStore registries = new RegistryEntryStore();
    Map<Block, Item.Properties> blockItemBuilders = Maps.newHashMap();
    Set<Object> noCategories = Sets.newHashSet();
    Set<Block> noItems = Sets.newHashSet();

    public KiwiModuleContainer(ResourceLocation rl, AbstractModule module, ModContext context) {
        this.module = module;
        this.context = context;
        module.uid = rl;
    }

    public <T> KiwiGOHolder<T> register(T object, ResourceKey<T> key, @Nullable Field field) {
        KiwiModule.Category group;
        KiwiGOHolder<T> entry = new KiwiGOHolder<T>(object, key, field);
        this.registries.put(entry);
        if (field != null && (group = field.getAnnotation(KiwiModule.Category.class)) != null) {
            entry.groupSetting = GroupSetting.of(group, this.groupSetting);
        }
        return entry;
    }

    public void loadGameObjects(RegistryLookup registryLookup) {
        KiwiModule.Category group;
        boolean useOwnGroup;
        this.context.setActiveContainer();
        boolean bl = useOwnGroup = this.groupSetting == null;
        if (useOwnGroup && (group = this.module.getClass().getDeclaredAnnotation(KiwiModule.Category.class)) != null && group.value().length > 0) {
            useOwnGroup = false;
            this.groupSetting = GroupSetting.of(group, null);
        }
        String modid = this.module.uid.getNamespace();
        Item.Properties tmpBuilder = null;
        Field tmpBuilderField = null;
        for (Field field : this.module.getClass().getFields()) {
            ResourceKey resourceKey;
            ResourceKey<? extends Registry<?>> registryKey;
            int mods;
            if (field.getAnnotation(KiwiModule.Skip.class) != null || !Modifier.isPublic(mods = field.getModifiers()) || !Modifier.isStatic(mods)) continue;
            KiwiModule.Name nameAnnotation = field.getAnnotation(KiwiModule.Name.class);
            ResourceLocation id = nameAnnotation != null ? KUtil.RL(nameAnnotation.value(), modid) : KUtil.RL(field.getName().toLowerCase(Locale.ENGLISH), modid);
            Objects.requireNonNull(id);
            if (field.getType() == this.module.getClass() && "instance".equals(id.getPath()) && id.getNamespace().equals(modid)) {
                try {
                    field.set(null, this.module);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Kiwi.LOGGER.error("Kiwi failed to inject module instance to module class: %s".formatted(this.module.uid), (Throwable)e);
                }
                continue;
            }
            Object o = null;
            try {
                o = field.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Kiwi.LOGGER.error("Kiwi failed to catch game object: %s".formatted(field), (Throwable)e);
            }
            if (o == null) continue;
            if (o instanceof Item.Properties) {
                Item.Properties properties;
                tmpBuilder = properties = (Item.Properties)o;
                tmpBuilderField = field;
                continue;
            }
            if (o instanceof KiwiGO) {
                KiwiGO kiwiGO = (KiwiGO)o;
                o = kiwiGO.getOrCreate();
                registryKey = kiwiGO.findRegistry();
                resourceKey = ResourceKey.create(registryKey, (ResourceLocation)id);
                kiwiGO.setKey(resourceKey);
            } else {
                registryKey = registryLookup.findRegistry(o);
                if (registryKey == null) {
                    tmpBuilder = null;
                    tmpBuilderField = null;
                    continue;
                }
                resourceKey = ResourceKey.create(registryKey, (ResourceLocation)id);
            }
            if (o instanceof Block) {
                if (field.getAnnotation(KiwiModule.NoItem.class) != null) {
                    this.noItems.add((Block)o);
                }
                this.checkNoGroup(field, o);
                if (tmpBuilder != null) {
                    this.blockItemBuilders.put((Block)o, tmpBuilder);
                    try {
                        tmpBuilderField.set(this.module, null);
                    }
                    catch (Exception e) {
                        Kiwi.LOGGER.error("Kiwi failed to clean used item builder: %s".formatted(tmpBuilderField), (Throwable)e);
                    }
                }
            } else if (o instanceof Item) {
                this.checkNoGroup(field, o);
            } else if (useOwnGroup && this.groupSetting == null && o instanceof CreativeModeTab) {
                this.groupSetting = new GroupSetting(new String[]{id.toString()}, new String[0]);
            }
            KiwiGOHolder<Object> entry = this.register(o, resourceKey, field);
            if (Registries.MOB_EFFECT == registryKey) {
                BiConsumer<KiwiModuleContainer, KiwiGOHolder> decorator = this.module.decorators.getOrDefault(registryKey, (a, b) -> {});
                decorator.accept(this, entry);
                entry.register();
            }
            tmpBuilder = null;
            tmpBuilderField = null;
        }
    }

    private void checkNoGroup(Field field, Object o) {
        if (field.getAnnotation(KiwiModule.NoCategory.class) != null) {
            this.noCategories.add(o);
        }
    }

    public void registerGameObjects(ResourceKey<? extends Registry<?>> registryKey) {
        if (Registries.MOB_EFFECT == registryKey) {
            return;
        }
        this.context.setActiveContainer();
        Collection entries = this.registries.registries.get((Object)registryKey.location());
        BiConsumer<KiwiModuleContainer, KiwiGOHolder> decorator = this.module.decorators.getOrDefault(registryKey, (a, b) -> {});
        if (Registries.ITEM == registryKey) {
            this.registries.get(Registries.BLOCK).forEach(e -> {
                BlockItem item;
                Object patt0$temp;
                if (this.noItems.contains(e.value)) {
                    return;
                }
                Item.Properties builder = this.blockItemBuilders.get(e.value);
                if (builder == null) {
                    builder = new Item.Properties();
                }
                if ((patt0$temp = e.value) instanceof IKiwiBlock) {
                    IKiwiBlock kiwiBlock = (IKiwiBlock)patt0$temp;
                    item = kiwiBlock.createItem(builder);
                } else {
                    item = new ModBlockItem((Block)e.value, builder);
                }
                if (this.noCategories.contains(e.value)) {
                    this.noCategories.add(item);
                }
                KiwiGOHolder<BlockItem> itemEntry = new KiwiGOHolder<BlockItem>(item, ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)e.key.location()), null);
                itemEntry.groupSetting = e.groupSetting;
                entries.add(itemEntry);
            });
            LinkedHashSet groupSettings = Sets.newLinkedHashSet();
            MutableObject prevSetting = new MutableObject();
            if (this.groupSetting != null) {
                prevSetting.setValue((Object)this.groupSetting);
                groupSettings.add(this.groupSetting);
            }
            entries.forEach(e -> {
                Item item = (Item)e.value;
                if (this.noCategories.contains(item)) {
                    prevSetting.setValue((Object)this.groupSetting);
                    return;
                }
                ItemCategoryFiller filler = item instanceof ItemCategoryFiller ? (ItemCategoryFiller)item : (tab, flags, hasPermissions, items) -> items.add(new ItemStack((ItemLike)item));
                if (e.groupSetting != null) {
                    e.groupSetting.apply(filler);
                    groupSettings.add(e.groupSetting);
                    prevSetting.setValue((Object)e.groupSetting);
                } else if (prevSetting.getValue() != null) {
                    ((GroupSetting)prevSetting.getValue()).apply(filler);
                }
            });
            groupSettings.forEach(GroupSetting::postApply);
        }
        entries.forEach(e -> {
            decorator.accept(this, (KiwiGOHolder)e);
            e.register();
        });
        if (Registries.ITEM == registryKey) {
            this.blockItemBuilders = null;
            this.noCategories = null;
            this.noItems = null;
        } else if (Registries.BLOCK == registryKey && Platform.isPhysicalClient() && !Platform.isDataGen()) {
            RenderType solid = RenderType.solid();
            HashMap cache = Maps.newHashMap();
            entries.forEach(e -> {
                RenderType type;
                KiwiModule.RenderLayer layer;
                Block block = (Block)e.value;
                if (e.field != null && (layer = e.field.getAnnotation(KiwiModule.RenderLayer.class)) != null && (type = (RenderType)layer.value().value) != solid && type != null) {
                    ClientPlatform.setRenderType(block, type);
                    return;
                }
                Class<?> klass = block.getClass();
                type = cache.computeIfAbsent(klass, k -> {
                    while (k != Block.class) {
                        KiwiModule.RenderLayer layer = k.getDeclaredAnnotation(KiwiModule.RenderLayer.class);
                        if (layer != null) {
                            return (RenderType)layer.value().value;
                        }
                        k = k.getSuperclass();
                    }
                    return solid;
                });
                if (type != solid && type != null) {
                    ClientPlatform.setRenderType(block, type);
                }
            });
        }
    }

    public void addRegistries() {
        this.context.setActiveContainer();
        this.module.addRegistries();
    }

    public void addEntries() {
        this.context.setActiveContainer();
        this.module.addEntries();
        this.registries.registries.keySet().stream().map(ResourceKey::createRegistryKey).forEach(KiwiModules.ALL_USED_REGISTRIES::add);
        KiwiModules.ALL_USED_REGISTRIES.forEach(this::registerGameObjects);
    }

    public void init(InitEvent event) {
        this.context.setActiveContainer();
        this.module.init(event);
    }

    public void postInit(PostInitEvent event) {
        this.context.setActiveContainer();
        this.module.postInit(event);
    }

    public <T> List<T> getRegistries(ResourceKey<Registry<T>> registry) {
        return this.getRegistryEntries(registry).map($ -> $.value).toList();
    }

    public <T> Stream<KiwiGOHolder<T>> getRegistryEntries(ResourceKey<Registry<T>> registry) {
        return this.registries.get(registry).stream();
    }

    public static final class RegistryEntryStore {
        final Multimap<ResourceLocation, KiwiGOHolder<?>> registries = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().linkedListValues().build();

        <T> void put(KiwiGOHolder<T> entry) {
            this.registries.put((Object)entry.key.registry(), entry);
        }

        <T> Collection<KiwiGOHolder<T>> get(ResourceKey<Registry<T>> registry) {
            return this.registries.get((Object)registry.location());
        }
    }
}

