/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;

public class KiwiGO<T>
implements Supplier<T> {
    private Supplier<T> factory;
    private ResourceKey<T> key;
    private T value;

    public KiwiGO(Supplier<T> factory) {
        this.factory = factory;
    }

    @Override
    public T get() {
        Objects.requireNonNull(this.value);
        return this.value;
    }

    public T getOrCreate() {
        if (this.value == null) {
            this.value = this.factory.get();
            this.factory = null;
        }
        return this.get();
    }

    public void setKey(ResourceKey<T> key) {
        Objects.requireNonNull(key);
        if (this.key != null) {
            throw new IllegalStateException("Key already set: " + String.valueOf(this.key) + " -> " + String.valueOf(key));
        }
        this.key = key;
    }

    public boolean is(Object value) {
        if (this.key == null) {
            return false;
        }
        return Objects.equals(this.value, value);
    }

    public boolean is(ItemStack stack) {
        if (this.key == null || stack.isEmpty()) {
            return false;
        }
        return stack.is(((ItemLike)this.value).asItem());
    }

    public boolean is(BlockState state) {
        if (this.key == null) {
            return false;
        }
        return state.is((Block)this.value);
    }

    public BlockState defaultBlockState() {
        return ((Block)this.value).defaultBlockState();
    }

    public ItemStack itemStack() {
        return this.itemStack(1);
    }

    public ItemStack itemStack(int amount) {
        ItemStack stack = ((ItemLike)this.value).asItem().getDefaultInstance();
        if (!stack.isEmpty()) {
            stack.setCount(amount);
        }
        return stack;
    }

    public ResourceLocation key() {
        return this.key.location();
    }

    public ResourceKey<T> resourceKey() {
        return this.key;
    }

    @Nullable
    public ResourceKey<? extends Registry<?>> findRegistry() {
        return Kiwi.registryLookup.findRegistry(this.value);
    }

    public Optional<? extends Holder<T>> holder() {
        if (this.key == null) {
            return Optional.empty();
        }
        Registry registry = (Registry)BuiltInRegistries.REGISTRY.get(this.key.registry());
        if (registry == null) {
            return Optional.empty();
        }
        return registry.getHolder(this.key);
    }

    public static class RegistrySpecified<T>
    extends KiwiGO<T> {
        final ResourceKey<? extends Registry<?>> registryKey;

        public RegistrySpecified(Supplier<T> factory, ResourceKey<? extends Registry<?>> registryKey) {
            super(factory);
            this.registryKey = registryKey;
        }

        @Override
        public ResourceKey<? extends Registry<?>> findRegistry() {
            return this.registryKey;
        }
    }
}

