/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.network;

import java.util.List;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.JadeIds;
import snownee.jade.impl.EntityAccessorImpl;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.network.ReceiveDataPacket;
import snownee.jade.network.ServerPayloadContext;

public record RequestEntityPacket(EntityAccessorImpl.SyncData data, List<@Nullable IServerDataProvider<EntityAccessor>> dataProviders) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestEntityPacket> TYPE = new CustomPacketPayload.Type(JadeIds.PACKET_REQUEST_ENTITY);
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestEntityPacket> CODEC = StreamCodec.composite(EntityAccessorImpl.SyncData.STREAM_CODEC, RequestEntityPacket::data, (StreamCodec)ByteBufCodecs.list().apply(ByteBufCodecs.idMapper($ -> (IServerDataProvider)Objects.requireNonNull(WailaCommonRegistration.instance().entityDataProviders.idMapper()).byId($), $ -> Objects.requireNonNull(WailaCommonRegistration.instance().entityDataProviders.idMapper()).getIdOrThrow($))), RequestEntityPacket::dataProviders, RequestEntityPacket::new);

    public static void handle(RequestEntityPacket message, ServerPayloadContext context) {
        EntityAccessorImpl.handleRequest(message, context, tag -> ReceiveDataPacket.send(tag, context));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

