/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.JadeIds;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.overlay.DisplayHelper;

public class ArmorElement
extends Element {
    public static final ResourceLocation ARMOR = ResourceLocation.withDefaultNamespace((String)"hud/armor_full");
    public static final ResourceLocation HALF_ARMOR = ResourceLocation.withDefaultNamespace((String)"hud/armor_half");
    public static final ResourceLocation EMPTY_ARMOR = ResourceLocation.withDefaultNamespace((String)"hud/armor_empty");
    private final float armor;
    private String text;
    private int iconsPerLine = 1;
    private int lineCount = 1;
    private int iconCount = 1;

    public ArmorElement(float armor) {
        this.armor = armor;
        if (armor > (float)PluginConfig.INSTANCE.getInt(JadeIds.MC_ENTITY_ARMOR_MAX_FOR_RENDER)) {
            if (!PluginConfig.INSTANCE.get(JadeIds.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
                armor = Mth.ceil((float)armor);
            }
            this.text = DisplayHelper.dfCommas.format(armor);
        } else {
            int maxHeartsPerLine = PluginConfig.INSTANCE.getInt(JadeIds.MC_ENTITY_HEALTH_ICONS_PER_LINE);
            this.iconCount = Mth.ceil((float)(armor *= 0.5f));
            this.iconsPerLine = Math.min(maxHeartsPerLine, this.iconCount);
            this.lineCount = Mth.ceil((float)(armor / (float)maxHeartsPerLine));
        }
    }

    @Override
    public Vec2 getSize() {
        if (this.showText()) {
            Font font = Minecraft.getInstance().font;
            return new Vec2((float)(font.width(this.text) + 10), 9.0f);
        }
        return new Vec2((float)(8 * this.iconsPerLine + 1), (float)(5 + 4 * this.lineCount));
    }

    @Override
    public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
        IDisplayHelper helper = IDisplayHelper.get();
        int xOffset = (this.iconCount - 1) % this.iconsPerLine * 8;
        int yOffset = this.lineCount * 4 - 4;
        for (int i = this.iconCount; i > 0; --i) {
            helper.blitSprite(guiGraphics, EMPTY_ARMOR, (int)(x + (float)xOffset), (int)(y + (float)yOffset), 9, 9);
            if (i <= Mth.floor((float)this.armor)) {
                helper.blitSprite(guiGraphics, ARMOR, (int)(x + (float)xOffset), (int)(y + (float)yOffset), 9, 9);
            }
            if ((float)i > this.armor && (float)i < this.armor + 1.0f) {
                helper.blitSprite(guiGraphics, HALF_ARMOR, (int)(x + (float)xOffset), (int)(y + (float)yOffset), 9, 9);
            }
            if ((xOffset -= 8) >= 0) continue;
            xOffset = this.iconsPerLine * 8 - 8;
            yOffset -= 4;
        }
        if (this.showText()) {
            helper.drawText(guiGraphics, this.text, x + 10.0f, y + 1.0f, IThemeHelper.get().getNormalColor());
        }
    }

    @Override
    @Nullable
    public String getMessage() {
        return I18n.get((String)"narration.jade.armor", (Object[])new Object[]{Mth.ceil((float)this.armor)});
    }

    public boolean showText() {
        return this.text != null;
    }
}

