/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public abstract class FluidStorageProvider<T extends Accessor<?>>
implements IComponentProvider<T>,
IServerDataProvider<T> {
    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        List groups;
        if (!accessor.showDetails() && config.get(JadeIds.UNIVERSAL_FLUID_STORAGE_DETAILED)) {
            return;
        }
        if (!accessor.getServerData().contains("JadeFluidStorage")) {
            return;
        }
        IClientExtensionProvider provider = Optional.ofNullable(ResourceLocation.tryParse((String)accessor.getServerData().getString("JadeFluidStorageUid"))).map(WailaClientRegistration.instance().fluidStorageProviders::get).orElse(null);
        if (provider == null) {
            return;
        }
        try {
            groups = provider.getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeFluidStorage", Function.identity()));
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, provider, tooltip::add);
            return;
        }
        if (groups.isEmpty()) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        boolean renderGroup = groups.size() > 1 || groups.getFirst().shouldRenderGroup();
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            if (renderGroup) {
                group.renderHeader((ITooltip)theTooltip);
            }
            for (FluidView view : group.views) {
                Object text = view.overrideText != null ? view.overrideText : (view.fluidName == null ? Component.literal((String)view.current) : (accessor.showDetails() ? Component.translatable((String)"jade.fluid2", (Object[])new Object[]{IDisplayHelper.get().stripColor(view.fluidName).withStyle(ChatFormatting.WHITE), Component.literal((String)view.current).withStyle(ChatFormatting.WHITE), view.max}).withStyle(ChatFormatting.GRAY) : Component.translatable((String)"jade.fluid", (Object[])new Object[]{IDisplayHelper.get().stripColor(view.fluidName), view.current})));
                ProgressStyle progressStyle = helper.progressStyle().overlay(view.overlay);
                theTooltip.add(helper.progress(view.ratio, (Component)text, progressStyle, BoxStyle.getNestedBox(), true));
            }
        });
    }

    public static void putData(Accessor<?> accessor) {
        CompoundTag tag = accessor.getServerData();
        for (IServerExtensionProvider provider : WailaCommonRegistration.instance().fluidStorageProviders.get(accessor)) {
            List groups;
            try {
                groups = provider.getGroups(accessor);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, provider, null);
                continue;
            }
            if (groups == null) continue;
            if (ViewGroup.saveList(tag, "JadeFluidStorage", groups, Function.identity())) {
                tag.putString("JadeFluidStorageUid", provider.getUid().toString());
            }
            return;
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.UNIVERSAL_FLUID_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, T accessor, IPluginConfig config) {
        FluidStorageProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(CompoundTag data, T accessor) {
        FluidStorageProvider.putData(accessor);
    }

    @Override
    public boolean shouldRequestData(T accessor) {
        if (!accessor.showDetails() && IWailaConfig.get().getPlugin().get(JadeIds.UNIVERSAL_FLUID_STORAGE_DETAILED)) {
            return false;
        }
        for (IServerExtensionProvider provider : WailaCommonRegistration.instance().fluidStorageProviders.get(accessor)) {
            if (!provider.shouldRequestData((Accessor<?>)accessor)) continue;
            return true;
        }
        return false;
    }

    public static class ForBlock
    extends FluidStorageProvider<BlockAccessor> {
        private static final ForBlock INSTANCE = new ForBlock();
    }

    public static class ForEntity
    extends FluidStorageProvider<EntityAccessor> {
        private static final ForEntity INSTANCE = new ForEntity();
    }

    public static enum Extension implements IServerExtensionProvider<CompoundTag>,
    IClientExtensionProvider<CompoundTag, FluidView>
    {
        INSTANCE;


        @Override
        public ResourceLocation getUid() {
            return JadeIds.UNIVERSAL_FLUID_STORAGE_DEFAULT;
        }

        @Override
        public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> groups) {
            return ClientViewGroup.map(groups, FluidView::readDefault, null);
        }

        @Override
        @Nullable
        public List<ViewGroup<CompoundTag>> getGroups(Accessor<?> accessor) {
            return CommonProxy.wrapFluidStorage(accessor);
        }

        @Override
        public boolean shouldRequestData(Accessor<?> accessor) {
            return CommonProxy.hasDefaultFluidStorage(accessor);
        }

        @Override
        public int getDefaultPriority() {
            return 9999;
        }
    }
}

