/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.client;

import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class GatewayTickableSound
extends AbstractTickableSoundInstance {
    private final GatewayEntity gateway;

    public GatewayTickableSound(GatewayEntity gateway) {
        super((SoundEvent)GatewayObjects.GATE_AMBIENT.value(), SoundSource.HOSTILE, gateway.level().getRandom());
        this.gateway = gateway;
        this.looping = true;
        this.delay = 0;
        this.x = (float)gateway.getX();
        this.y = (float)gateway.getY();
        this.z = (float)gateway.getZ();
        this.relative = true;
        this.pitch = 0.75f;
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        if (!this.gateway.isAlive()) {
            this.stop();
        } else {
            this.volume = 0.35f - (float)(Minecraft.getInstance().player.distanceToSqr((Entity)this.gateway) / 324.0) / 4.0f;
        }
    }

    public static void startGatewaySound(GatewayEntity entity) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new GatewayTickableSound(entity));
    }
}

