/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree.breaking;

import fr.rakambda.fallingtree.common.config.enums.DamageRounding;
import fr.rakambda.fallingtree.common.config.enums.DurabilityMode;
import fr.rakambda.fallingtree.common.config.enums.MaxSizeAction;
import fr.rakambda.fallingtree.common.tree.breaking.BreakTreeTooBigException;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ToolDamageHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(ToolDamageHandler.class);
    private final IItemStack tool;
    private final double damageMultiplicand;
    private final DamageRounding damageRounding;
    private final int maxDurabilityTaken;
    private final int maxBreakCount;
    private boolean preserveTool;

    public ToolDamageHandler(@NotNull IItemStack tool, double damageMultiplicand, @NotNull DurabilityMode durabilityMode, int breakableCount, int maxSize, @NotNull MaxSizeAction maxSizeAction, @NotNull DamageRounding damageRounding) throws BreakTreeTooBigException {
        int tempMaxBreakCount;
        this.tool = tool;
        this.damageMultiplicand = damageMultiplicand;
        this.damageRounding = damageRounding;
        if (breakableCount > maxSize && maxSizeAction == MaxSizeAction.ABORT) {
            log.debug("Tree reached max size of {}", (Object)maxSize);
            throw new BreakTreeTooBigException();
        }
        if (tool.isDamageable()) {
            int breakCount = damageMultiplicand == 0.0 ? maxSize : (int)Math.floor((double)this.getToolDurability() / damageMultiplicand);
            tempMaxBreakCount = breakCount = durabilityMode.postProcess(breakCount, breakableCount);
        } else {
            tempMaxBreakCount = maxSize;
        }
        this.preserveTool = tempMaxBreakCount < 0;
        tempMaxBreakCount = Math.max(0, tempMaxBreakCount);
        this.maxBreakCount = Math.min(maxSize, tempMaxBreakCount);
        this.maxDurabilityTaken = this.getDamage(this.maxBreakCount);
    }

    private int getDamage(long count) {
        if (Double.compare(this.damageMultiplicand, 0.0) <= 0) {
            return 1;
        }
        double rawDamage = (double)count * this.damageMultiplicand;
        return switch (this.damageRounding) {
            default -> throw new MatchException(null, null);
            case DamageRounding.ROUND_DOWN -> (int)Math.floor(rawDamage);
            case DamageRounding.ROUND_UP -> (int)Math.ceil(rawDamage);
            case DamageRounding.ROUNDING -> (int)Math.round(rawDamage);
            case DamageRounding.PROBABILISTIC -> this.getProbabilisticDamage(rawDamage);
        };
    }

    private int getProbabilisticDamage(double rawDamage) {
        double damage = Math.floor(rawDamage);
        int finalDamage = (int)damage;
        double probability = rawDamage - damage;
        if (Math.random() < probability) {
            ++finalDamage;
        }
        return finalDamage;
    }

    public int getActualDamage(int brokenCount) {
        if (this.tool.isDamageable()) {
            return brokenCount == this.maxBreakCount ? this.maxDurabilityTaken : Math.min(this.maxDurabilityTaken, this.getDamage(brokenCount));
        }
        return 0;
    }

    private int getToolDurability() {
        if (this.tool.isDamageable()) {
            return this.tool.getMaxDamage() - this.tool.getDamage();
        }
        return Integer.MAX_VALUE;
    }

    @Generated
    public int getMaxBreakCount() {
        return this.maxBreakCount;
    }

    @Generated
    public boolean isPreserveTool() {
        return this.preserveTool;
    }
}

