/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.config.ModifiableItems;
import fuzs.enchantinginfuser.config.ServerConfig;
import fuzs.enchantinginfuser.init.ModRegistry;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.enchantinginfuser.world.item.enchantment.EnchantingBehavior;
import fuzs.enchantinginfuser.world.level.block.InfuserType;
import fuzs.enchantinginfuser.world.level.block.entity.InfuserBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.puzzleslib.api.core.v1.Proxy;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class InfuserBlock
extends BaseEntityBlock
implements TickingEntityBlock<InfuserBlockEntity> {
    public static final MapCodec<InfuserBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)InfuserType.CODEC.fieldOf("type").forGetter(infuserBlock -> infuserBlock.type), (App)InfuserBlock.propertiesCodec()).apply((Applicative)instance, InfuserBlock::new));
    public static final Component COMPONENT_CHOOSE = Component.translatable((String)"block.enchantinginfuser.description.choose");
    public static final Component COMPONENT_CHOOSE_AND_MODIFY = Component.translatable((String)"block.enchantinginfuser.description.chooseAndModify");
    public static final Component COMPONENT_REPAIR = Component.translatable((String)"block.enchantinginfuser.description.repair");
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private final InfuserType type;

    public InfuserBlock(InfuserType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
    }

    public static boolean isValidBookShelf(Level level, BlockPos pos, BlockPos offset) {
        if (EnchantingBehavior.get().getEnchantmentPower(level.getBlockState(pos.offset((Vec3i)offset)), level, pos.offset((Vec3i)offset)) != 0.0f) {
            BlockPos inBetweenPos = pos.offset(offset.getX() / 2, offset.getY(), offset.getZ() / 2);
            return level.getBlockState(inBetweenPos).getCollisionShape((BlockGetter)level, inBetweenPos) != Shapes.block();
        }
        return false;
    }

    public MapCodec<InfuserBlock> codec() {
        return CODEC;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockEntityType<? extends InfuserBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.INFUSER_BLOCK_ENTITY_TYPE.value();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof InfuserBlockEntity) {
            InfuserBlockEntity blockEntity2 = (InfuserBlockEntity)blockEntity;
            if (!level.isClientSide) {
                player.openMenu(state.getMenuProvider(level, pos));
                player.containerMenu.slotsChanged((Container)blockEntity2);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState blockState, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof InfuserBlockEntity) {
            InfuserBlockEntity blockEntity2 = (InfuserBlockEntity)blockEntity;
            Component component = blockEntity2.getDisplayName();
            return new SimpleMenuProvider((containerId, inventory, player) -> {
                if (blockEntity2.canOpen(player)) {
                    InfuserMenu menu = new InfuserMenu(this.type, containerId, inventory, (Container)blockEntity2, ContainerLevelAccess.create((Level)level, (BlockPos)blockPos));
                    menu.addSlotListener(menu);
                    return menu;
                }
                return null;
            }, component);
        }
        return null;
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        for (BlockPos offset : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
            if (random.nextInt(16) != 0 || !InfuserBlock.isValidBookShelf(level, pos, offset)) continue;
            level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, (double)((float)offset.getX() + random.nextFloat()) - 0.5, (double)((float)offset.getY() - random.nextFloat() - 1.0f), (double)((float)offset.getZ() + random.nextFloat()) - 0.5);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isPathfindable(BlockState blockState, PathComputationType type) {
        return false;
    }

    public void onRemove(BlockState blockState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!blockState.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof InfuserBlockEntity) {
            InfuserBlockEntity blockEntity2 = (InfuserBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)blockEntity2);
        }
        super.onRemove(blockState, level, pos, newState, isMoving);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (!EnchantingInfuser.CONFIG.getHolder(ServerConfig.class).isAvailable()) {
            return;
        }
        Component component = this.type.getConfig().allowModifyingEnchantments == ModifiableItems.UNENCHANTED ? COMPONENT_CHOOSE : COMPONENT_CHOOSE_AND_MODIFY;
        MutableComponent mutableComponent = Component.empty().append(component).withStyle(ChatFormatting.GRAY);
        if (this.type.getConfig().allowRepairing.isActive()) {
            mutableComponent = mutableComponent.append(" ").append(COMPONENT_REPAIR);
        }
        tooltipComponents.addAll(Proxy.INSTANCE.splitTooltipLines((Component)mutableComponent));
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        InfuserBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof InfuserBlockEntity && !(blockEntity = (InfuserBlockEntity)blockEntity2).getItem(0).isEmpty()) {
            return 15;
        }
        return 0;
    }
}

