/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import noppes.npcs.NBTTags;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;
import noppes.npcs.util.ValueUtil;

public class JobHealer
extends JobInterface {
    private int healTicks = 0;
    public int range = 8;
    public byte type = (byte)2;
    public int speed = 20;
    public HashMap<Integer, Integer> effects = new HashMap();
    private List<LivingEntity> affected = new ArrayList<LivingEntity>();

    public JobHealer(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public CompoundTag save(CompoundTag nbttagcompound) {
        nbttagcompound.putInt("HealerRange", this.range);
        nbttagcompound.putByte("HealerType", this.type);
        nbttagcompound.put("BeaconEffects", (Tag)NBTTags.nbtIntegerIntegerMap(this.effects));
        nbttagcompound.putInt("HealerSpeed", this.speed);
        return nbttagcompound;
    }

    @Override
    public void load(CompoundTag nbttagcompound) {
        this.range = nbttagcompound.getInt("HealerRange");
        this.type = nbttagcompound.getByte("HealerType");
        this.effects = NBTTags.getIntegerIntegerMap(nbttagcompound.getList("BeaconEffects", 10));
        this.speed = ValueUtil.CorrectInt(nbttagcompound.getInt("HealerSpeed"), 10, Integer.MAX_VALUE);
    }

    @Override
    public boolean aiShouldExecute() {
        ++this.healTicks;
        if (this.healTicks < this.speed) {
            return false;
        }
        this.healTicks = 0;
        this.affected = this.npc.level().getEntitiesOfClass(LivingEntity.class, this.npc.getBoundingBox().inflate((double)this.range, (double)this.range / 2.0, (double)this.range));
        return !this.affected.isEmpty();
    }

    @Override
    public boolean aiContinueExecute() {
        return false;
    }

    @Override
    public void aiStartExecuting() {
        for (LivingEntity entity : this.affected) {
            boolean isEnemy = false;
            isEnemy = entity instanceof Player ? this.npc.faction.isAggressiveToPlayer((Player)entity) : (entity instanceof EntityNPCInterface ? this.npc.faction.isAggressiveToNpc((EntityNPCInterface)entity) : entity instanceof Mob);
            if (entity == this.npc || this.type == 0 && isEnemy || this.type == 1 && !isEnemy) continue;
            for (Integer potionEffect : this.effects.keySet()) {
                MobEffect p = (MobEffect)BuiltInRegistries.MOB_EFFECT.byId(potionEffect.intValue());
                if (p == null) continue;
                entity.addEffect(new MobEffectInstance(Holder.direct((Object)p), 100, this.effects.get(potionEffect).intValue()));
            }
        }
        this.affected.clear();
    }

    @Override
    public int getType() {
        return 2;
    }
}

