/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.blocks.tiles.TileCopy;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.packets.PacketServerBasic;
import noppes.npcs.packets.server.SPacketTileEntitySave;

public class SPacketSchematicsStore
extends PacketServerBasic {
    private String name;
    private CompoundTag data;

    public SPacketSchematicsStore(String name, CompoundTag data) {
        this.name = name;
        this.data = data;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return item.getItem() == CustomItems.wand || item.getItem() == CustomBlocks.copy_item;
    }

    public static void encode(SPacketSchematicsStore msg, FriendlyByteBuf buf) {
        buf.writeUtf(msg.name);
        buf.writeNbt((Tag)msg.data);
    }

    public static SPacketSchematicsStore decode(FriendlyByteBuf buf) {
        return new SPacketSchematicsStore(buf.readUtf(Short.MAX_VALUE), buf.readNbt());
    }

    @Override
    protected void handle() {
        TileCopy tile = (TileCopy)SPacketTileEntitySave.saveTileEntity(this.player, this.data);
        if (tile == null || this.name.isEmpty()) {
            return;
        }
        SchematicController.Instance.save(this.player.createCommandSourceStack(), this.name, tile.getBlockPos(), tile.height, tile.width, tile.length);
    }
}

