/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.client;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.shared.common.PacketBasic;

public class PacketConfigFont
extends PacketBasic {
    private final String font;
    private final int size;

    public PacketConfigFont(String font, int size) {
        this.font = font;
        this.size = size;
    }

    public static void encode(PacketConfigFont msg, FriendlyByteBuf buf) {
        buf.writeUtf(msg.font);
        buf.writeInt(msg.size);
    }

    public static PacketConfigFont decode(FriendlyByteBuf buf) {
        return new PacketConfigFont(buf.readUtf(Short.MAX_VALUE), buf.readInt());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handle() {
        Runnable run = () -> {
            if (!this.font.isEmpty()) {
                CustomNpcs.FontType = this.font;
                CustomNpcs.FontSize = this.size;
                ClientProxy.Font.clear();
                ClientProxy.Font = new ClientProxy.FontContainer(CustomNpcs.FontType, CustomNpcs.FontSize);
                CustomNpcs.Config.updateConfig();
                this.player.sendSystemMessage((Component)Component.translatable((String)"Font set to %s", (Object[])new Object[]{ClientProxy.Font.getName()}));
            } else {
                this.player.sendSystemMessage((Component)Component.translatable((String)("Current font is " + ClientProxy.Font.getName())));
            }
        };
        Minecraft.getInstance().submit(run);
    }
}

