/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.BankData;

public class PlayerBankData {
    public HashMap<Integer, BankData> banks = new HashMap();

    public void loadNBTData(HolderLookup.Provider lookupProvider, CompoundTag compound) {
        HashMap<Integer, BankData> banks = new HashMap<Integer, BankData>();
        ListTag list = compound.getList("BankData", 10);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag nbttagcompound = list.getCompound(i);
            BankData data = new BankData();
            data.readNBT(lookupProvider, nbttagcompound);
            banks.put(data.bankId, data);
        }
        this.banks = banks;
    }

    public void saveNBTData(HolderLookup.Provider lookupProvider, CompoundTag playerData) {
        ListTag list = new ListTag();
        for (BankData data : this.banks.values()) {
            CompoundTag nbttagcompound = new CompoundTag();
            data.writeNBT(lookupProvider, nbttagcompound);
            list.add((Object)nbttagcompound);
        }
        playerData.put("BankData", (Tag)list);
    }

    public BankData getBank(int bankId) {
        return this.banks.get(bankId);
    }

    public BankData getBankOrDefault(HolderLookup.Provider lookupProvider, int bankId) {
        BankData data = this.banks.get(bankId);
        if (data != null) {
            return data;
        }
        Bank bank = BankController.getInstance(lookupProvider).getBank(bankId);
        return this.banks.get(bank.id);
    }

    public boolean hasBank(int bank) {
        return this.banks.containsKey(bank);
    }

    public void loadNew(int bank) {
        BankData data = new BankData();
        data.bankId = bank;
        this.banks.put(bank, data);
    }
}

