/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import noppes.npcs.ModelData;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.layer.LayerGlow;
import noppes.npcs.client.layer.LayerHeadwear;
import noppes.npcs.client.layer.LayerNpcCloak;
import noppes.npcs.client.layer.LayerParts;
import noppes.npcs.client.layer.LayerPreRender;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.constants.BodyPart;
import noppes.npcs.controllers.CobblemonHelper;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.LivingRenderer2Mixin;
import noppes.npcs.mixin.LivingRenderer3Mixin;

public class RenderCustomNpc<T extends EntityCustomNpc, M extends HumanoidModel<T>>
extends RenderNPCInterface<T, M> {
    private float partialTicks;
    private LivingEntity entity;
    private EntityNPCInterface npc;
    private LivingEntityRenderer renderEntity;
    public M npcmodel;
    public Model otherModel;
    public HumanoidArmorLayer armorLayer;
    public List<RenderLayer<T, M>> npclayers = Lists.newArrayList();
    private RenderLayer renderLayer = new RenderLayer(null){

        public void render(PoseStack mStack, MultiBufferSource typeBuffer, int lightmapUV, Entity p_225628_4_, float limbSwing, float limbSwingAmount, float partialTicks, float age, float netHeadYaw, float headPitch) {
            for (RenderLayer layer : ((LivingRenderer2Mixin)RenderCustomNpc.this.renderEntity).layers()) {
                layer.render(mStack, typeBuffer, lightmapUV, (Entity)RenderCustomNpc.this.entity, limbSwing, limbSwingAmount, partialTicks, age, netHeadYaw, headPitch);
            }
        }
    };
    private final HumanoidModel renderModel;

    public RenderCustomNpc(EntityRendererProvider.Context manager, M model) {
        super(manager, model, 0.5f);
        this.npcmodel = model;
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, manager.getModelSet(), manager.getItemInHandRenderer()));
        this.addLayer(new LayerHeadwear(this));
        this.addLayer(new LayerNpcCloak(this));
        this.addLayer(new LayerParts(this));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, manager.getItemInHandRenderer()));
        this.addLayer(new LayerGlow(this));
        HumanoidArmorLayer armorLayer = new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(manager.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(manager.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), manager.getModelManager());
        this.addLayer((RenderLayer)armorLayer);
        this.armorLayer = armorLayer;
        this.renderModel = new HumanoidModel(manager.bakeLayer(ModelLayers.PLAYER)){

            public void renderToBuffer(PoseStack mStack, VertexConsumer iVertex, int lightmapUV, int packedOverlayIn, int color) {
                float red = FastColor.ABGR32.red((int)color);
                float green = FastColor.ABGR32.green((int)color);
                float blue = FastColor.ABGR32.blue((int)color);
                float alpha = FastColor.ABGR32.alpha((int)color);
                int colorr = RenderCustomNpc.this.npc.display.getTint();
                if (colorr < 0xFFFFFF) {
                    red = (float)(colorr >> 16 & 0xFF) / 255.0f;
                    green = (float)(colorr >> 8 & 0xFF) / 255.0f;
                    blue = (float)(colorr & 0xFF) / 255.0f;
                }
                RenderCustomNpc.this.otherModel.renderToBuffer(mStack, iVertex, lightmapUV, packedOverlayIn, FastColor.ABGR32.color((int)((int)alpha), (int)((int)red), (int)((int)green), (int)((int)blue)));
            }

            public void setupAnim(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                if (RenderCustomNpc.this.otherModel instanceof EntityModel) {
                    EntityModel em = (EntityModel)RenderCustomNpc.this.otherModel;
                    em.setupAnim((Entity)RenderCustomNpc.this.entity, limbSwing, limbSwingAmount, ((LivingRenderer3Mixin)RenderCustomNpc.this.renderEntity).callGetBob(RenderCustomNpc.this.entity, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true)), netHeadYaw, headPitch);
                }
            }

            public void prepareMobModel(Entity npc, float animationPos, float animationSpeed, float partialTicks) {
                Model pixModel;
                if (PixelmonHelper.isPixelmon((Entity)RenderCustomNpc.this.entity) && (pixModel = (Model)PixelmonHelper.getModel(RenderCustomNpc.this.entity)) != null) {
                    RenderCustomNpc.this.otherModel = pixModel;
                    PixelmonHelper.setupModel(RenderCustomNpc.this.entity, pixModel);
                }
                if (RenderCustomNpc.this.otherModel instanceof HumanoidModel) {
                    HumanoidModel bm = (HumanoidModel)RenderCustomNpc.this.otherModel;
                    bm.swimAmount = ((EntityCustomNpc)npc).getSwimAmount(partialTicks);
                    bm.crouching = ((HumanoidModel)RenderCustomNpc.this.npcmodel).crouching;
                }
                if (RenderCustomNpc.this.otherModel instanceof EntityModel) {
                    EntityModel em = (EntityModel)RenderCustomNpc.this.otherModel;
                    em.riding = RenderCustomNpc.this.entity.isPassenger() && RenderCustomNpc.this.entity.getVehicle() != null;
                    em.young = RenderCustomNpc.this.entity.isBaby();
                    em.attackTime = RenderCustomNpc.this.getAttackAnim((LivingEntity)((EntityCustomNpc)npc), partialTicks);
                    em.prepareMobModel((Entity)RenderCustomNpc.this.entity, animationPos, animationSpeed, partialTicks);
                }
            }
        };
    }

    public Vec3 getRenderOffset(T npc, float partialTicks) {
        float xOffset = 0.0f;
        float yOffset = ((EntityCustomNpc)((Object)npc)).currentAnimation == 0 ? ((EntityCustomNpc)((Object)npc)).ais.bodyOffsetY / 10.0f - 0.5f : 0.0f;
        float zOffset = 0.0f;
        if (((EntityNPCInterface)((Object)npc)).isAlive()) {
            if (((EntityNPCInterface)((Object)npc)).isSleeping()) {
                xOffset = (float)(-Math.cos(Math.toRadians(180 - ((EntityCustomNpc)((Object)npc)).ais.orientation)));
                zOffset = (float)(-Math.sin(Math.toRadians(((EntityCustomNpc)((Object)npc)).ais.orientation)));
                yOffset += 0.14f;
            } else if (((EntityCustomNpc)((Object)npc)).currentAnimation == 1 || npc.isPassenger()) {
                yOffset -= 0.5f - ((EntityCustomNpc)((Object)npc)).modelData.getLegsY() * 0.8f;
            } else if (((EntityNPCInterface)((Object)npc)).isCrouching()) {
                yOffset = (float)((double)yOffset - 0.125);
            }
        }
        return new Vec3((double)xOffset, (double)(yOffset * ((float)((EntityCustomNpc)((Object)npc)).display.getSize() / 5.0f)), (double)zOffset);
    }

    void hideParts() {
        if (this.npc instanceof EntityCustomNpc) {
            ModelData data = ModelData.get((EntityCustomNpc)this.npc);
            ((HumanoidModel)this.npcmodel).leftLeg.visible = !data.hiddenParts.contains((Object)BodyPart.LEFT_LEG);
            ((HumanoidModel)this.npcmodel).rightLeg.visible = !data.hiddenParts.contains((Object)BodyPart.RIGHT_LEG);
            ((HumanoidModel)this.npcmodel).leftArm.visible = !data.hiddenParts.contains((Object)BodyPart.LEFT_ARM);
            ((HumanoidModel)this.npcmodel).rightArm.visible = !data.hiddenParts.contains((Object)BodyPart.RIGHT_ARM);
            ((HumanoidModel)this.npcmodel).body.visible = !data.hiddenParts.contains((Object)BodyPart.BODY);
            ((HumanoidModel)this.npcmodel).head.visible = !data.hiddenParts.contains((Object)BodyPart.HEAD);
            boolean bl = ((HumanoidModel)this.npcmodel).hat.visible = !data.hiddenParts.contains((Object)BodyPart.HEAD);
            if (this.npcmodel instanceof PlayerModel) {
                PlayerModel playerModel = (PlayerModel)this.npcmodel;
                playerModel.jacket.visible = !data.hiddenParts.contains((Object)BodyPart.BODY);
                playerModel.leftSleeve.visible = !data.hiddenParts.contains((Object)BodyPart.LEFT_ARM);
                playerModel.rightSleeve.visible = !data.hiddenParts.contains((Object)BodyPart.RIGHT_ARM);
                playerModel.leftPants.visible = !data.hiddenParts.contains((Object)BodyPart.LEFT_LEG);
                playerModel.rightPants.visible = !data.hiddenParts.contains((Object)BodyPart.RIGHT_LEG);
            }
        }
    }

    @Override
    public void render(T npc, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        this.npc = npc;
        this.partialTicks = partialTicks;
        LivingEntity prevEntity = this.entity;
        this.entity = ((EntityCustomNpc)((Object)npc)).modelData.getEntity((EntityNPCInterface)((Object)npc));
        if (prevEntity != null && this.entity == null) {
            this.model = this.npcmodel;
            this.renderEntity = null;
            this.layers.clear();
            this.layers.addAll(this.npclayers);
        }
        if (this.entity != null) {
            EntityRenderer render = this.entityRenderDispatcher.getRenderer((Entity)this.entity);
            if (((EntityCustomNpc)((Object)npc)).modelData.simpleRender) {
                this.renderEntity = null;
                matrixStack.pushPose();
                render.render((Entity)this.entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
                this.renderNameTag(npc, (Component)Component.empty(), matrixStack, buffer, packedLight, partialTicks);
                matrixStack.popPose();
                return;
            }
            if (render instanceof LivingEntityRenderer) {
                this.renderEntity = (LivingEntityRenderer)render;
                this.otherModel = this.renderEntity.getModel();
                if (CobblemonHelper.Enabled && CobblemonHelper.isPokemon((Entity)this.entity)) {
                    this.otherModel = CobblemonHelper.getPokemonModel((Entity)this.entity);
                }
                this.model = this.renderModel;
                this.layers.clear();
                this.layers.add(this.renderLayer);
                this.layers.add(new LayerGlow(this));
                if (render instanceof RenderCustomNpc) {
                    for (RenderLayer layer : ((LivingRenderer2Mixin)this.renderEntity).layers()) {
                        if (!(layer instanceof LayerPreRender)) continue;
                        ((LayerPreRender)layer).preRender((EntityCustomNpc)this.entity);
                    }
                }
            } else {
                this.renderEntity = null;
                this.entity = null;
                this.model = this.npcmodel;
                this.layers.clear();
                this.layers.addAll(this.npclayers);
            }
        } else {
            this.hideParts();
            List list = this.layers;
            for (RenderLayer layer : list) {
                if (!(layer instanceof LayerPreRender)) continue;
                ((LayerPreRender)layer).preRender((EntityCustomNpc)((Object)npc));
            }
        }
        ((HumanoidModel)this.npcmodel).rightArmPose = this.getPose(npc, ((EntityNPCInterface)((Object)npc)).getMainHandItem());
        ((HumanoidModel)this.npcmodel).leftArmPose = this.getPose(npc, ((EntityNPCInterface)((Object)npc)).getOffhandItem());
        super.render(npc, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected RenderType getRenderType(T p_230496_1_, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation resourcelocation = this.getTextureLocation(p_230496_1_);
        if (p_230496_2_ && this.model == this.renderModel) {
            return this.otherModel.renderType(resourcelocation);
        }
        if (this.entity == null) {
            return ((HumanoidModel)this.model).renderType(resourcelocation);
        }
        return super.getRenderType(p_230496_1_, p_230496_2_, p_230496_3_, p_230496_4_);
    }

    public HumanoidModel.ArmPose getPose(T npc, ItemStack item) {
        if (NoppesUtilServer.IsItemStackNull(item)) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (npc.getUseItemRemainingTicks() > 0) {
            UseAnim enumaction = item.getUseAnimation();
            if (enumaction == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (enumaction == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    @Override
    protected void scale(T npc, PoseStack matrixScale, float f) {
        if (this.renderEntity != null) {
            this.renderColor((EntityNPCInterface)((Object)npc));
            int size = ((EntityCustomNpc)((Object)npc)).display.getSize();
            if (this.entity instanceof EntityNPCInterface) {
                ((EntityNPCInterface)this.entity).display.setSize(5);
            }
            EntityRenderer render = this.entityRenderDispatcher.getRenderer((Entity)this.entity);
            if (!((EntityCustomNpc)((Object)npc)).modelData.simpleRender && render instanceof LivingEntityRenderer) {
                ((LivingRenderer3Mixin)render).callScale(this.entity, matrixScale, this.partialTicks);
            }
            ((EntityCustomNpc)((Object)npc)).display.setSize(size);
            matrixScale.scale(0.2f * (float)((EntityCustomNpc)((Object)npc)).display.getSize(), 0.2f * (float)((EntityCustomNpc)((Object)npc)).display.getSize(), 0.2f * (float)((EntityCustomNpc)((Object)npc)).display.getSize());
        } else {
            super.scale(npc, matrixScale, f);
        }
    }
}

