/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomNpcs;
import noppes.npcs.blocks.BlockNpcRedstone;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.mixin.MixinBlockBehaviour;

public class TileRedstoneBlock
extends TileNpcEntity {
    public int onRange = 12;
    public int offRange = 20;
    public int onRangeX = 12;
    public int onRangeY = 12;
    public int onRangeZ = 12;
    public int offRangeX = 20;
    public int offRangeY = 20;
    public int offRangeZ = 20;
    public boolean isDetailed = false;
    public Availability availability = new Availability();
    public boolean isActivated = false;
    private int ticks = 10;

    public TileRedstoneBlock(BlockPos pos, BlockState state) {
        super(CustomBlocks.tile_redstoneblock, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TileRedstoneBlock tile) {
        if (tile.level.isClientSide) {
            return;
        }
        --tile.ticks;
        if (tile.ticks > 0) {
            return;
        }
        tile.ticks = tile.onRange > 10 ? 20 : 10;
        Block block = state.getBlock();
        if (block == null || !(block instanceof BlockNpcRedstone)) {
            return;
        }
        if (CustomNpcs.FreezeNPCs) {
            if (tile.isActivated) {
                tile.setActive(block, false);
            }
            return;
        }
        if (!tile.isActivated) {
            int z;
            int y;
            int x = tile.isDetailed ? tile.onRangeX : tile.onRange;
            List<Player> list = tile.getPlayerList(x, y = tile.isDetailed ? tile.onRangeY : tile.onRange, z = tile.isDetailed ? tile.onRangeZ : tile.onRange);
            if (list.isEmpty()) {
                return;
            }
            for (Player player : list) {
                if (!tile.availability.isAvailable(player)) continue;
                tile.setActive(block, true);
                return;
            }
        } else {
            int x = tile.isDetailed ? tile.offRangeX : tile.offRange;
            int y = tile.isDetailed ? tile.offRangeY : tile.offRange;
            int z = tile.isDetailed ? tile.offRangeZ : tile.offRange;
            List<Player> list = tile.getPlayerList(x, y, z);
            for (Player player : list) {
                if (!tile.availability.isAvailable(player)) continue;
                return;
            }
            tile.setActive(block, false);
        }
    }

    private void setActive(Block block, boolean bo) {
        this.isActivated = bo;
        BlockState state = (BlockState)block.defaultBlockState().setValue((Property)BlockNpcRedstone.ACTIVE, (Comparable)Boolean.valueOf(this.isActivated));
        this.level.setBlock(this.worldPosition, state, 2);
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        ((MixinBlockBehaviour)block).invokeOnPlace(state, this.level, this.worldPosition, state, false);
    }

    private List<Player> getPlayerList(int x, int y, int z) {
        return this.level.getEntitiesOfClass(Player.class, new AABB((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (double)(this.worldPosition.getX() + 1), (double)(this.worldPosition.getY() + 1), (double)(this.worldPosition.getZ() + 1)).inflate((double)x, (double)y, (double)z));
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.onRange = compound.getInt("BlockOnRange");
        this.offRange = compound.getInt("BlockOffRange");
        this.isDetailed = compound.getBoolean("BlockIsDetailed");
        if (compound.contains("BlockOnRangeX")) {
            this.isDetailed = true;
            this.onRangeX = compound.getInt("BlockOnRangeX");
            this.onRangeY = compound.getInt("BlockOnRangeY");
            this.onRangeZ = compound.getInt("BlockOnRangeZ");
            this.offRangeX = compound.getInt("BlockOffRangeX");
            this.offRangeY = compound.getInt("BlockOffRangeY");
            this.offRangeZ = compound.getInt("BlockOffRangeZ");
        }
        if (compound.contains("BlockActivated")) {
            this.isActivated = compound.getBoolean("BlockActivated");
        }
        this.availability.load((HolderLookup.Provider)this.level.registryAccess(), compound);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        compound.putInt("BlockOnRange", this.onRange);
        compound.putInt("BlockOffRange", this.offRange);
        compound.putBoolean("BlockActivated", this.isActivated);
        compound.putBoolean("BlockIsDetailed", this.isDetailed);
        if (this.isDetailed) {
            compound.putInt("BlockOnRangeX", this.onRangeX);
            compound.putInt("BlockOnRangeY", this.onRangeY);
            compound.putInt("BlockOnRangeZ", this.onRangeZ);
            compound.putInt("BlockOffRangeX", this.offRangeX);
            compound.putInt("BlockOffRangeY", this.offRangeY);
            compound.putInt("BlockOffRangeZ", this.offRangeZ);
        }
        this.availability.save((HolderLookup.Provider)this.level.registryAccess(), compound);
        super.saveAdditional(compound, registries);
    }
}

