/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import noppes.npcs.CustomItems;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.blocks.tiles.TileCopy;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.packets.server.SPacketGuiOpen;

public class BlockCopy
extends BlockInterface {
    public static final MapCodec<BlockCopy> CODEC = BlockCopy.simpleCodec(BlockCopy::new);

    public BlockCopy() {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.BARRIER).mapColor(MapColor.METAL).sound(SoundType.STONE));
    }

    public BlockCopy(BlockBehaviour.Properties p_49696_) {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.BARRIER).mapColor(MapColor.METAL).sound(SoundType.STONE));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack != null && stack.getItem() == CustomItems.wand) {
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.CopyBlock, null, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (!context.getLevel().isClientSide) {
            SPacketGuiOpen.sendOpenGui(context.getPlayer(), EnumGuiType.CopyBlock, null, context.getClickedPos());
        }
        return this.defaultBlockState();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileCopy(pos, state);
    }
}

