/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.blocks.tiles.TileBorder;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.packets.server.SPacketGuiOpen;

public class BlockBorder
extends BlockInterface {
    public static final MapCodec<BlockBorder> CODEC = BlockBorder.simpleCodec(BlockBorder::new);
    public static final IntegerProperty ROTATION = IntegerProperty.create((String)"rotation", (int)0, (int)3);

    public BlockBorder() {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.BARRIER).mapColor(MapColor.METAL).sound(SoundType.STONE));
    }

    public BlockBorder(BlockBehaviour.Properties p_49696_) {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.BARRIER).mapColor(MapColor.METAL).sound(SoundType.STONE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ROTATION});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide && stack.getItem() == CustomItems.wand) {
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.Border, null, pos);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getPlayer() != null) {
            int l = Mth.floor((double)((double)(context.getPlayer().getYRot() * 4.0f / 360.0f) + 0.5)) & 3;
            return (BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(l %= 4));
        }
        return super.getStateForPlacement(context);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack item) {
        TileBorder tile = (TileBorder)level.getBlockEntity(pos);
        TileBorder adjacent = this.getTile(level, pos.west());
        if (adjacent == null) {
            adjacent = this.getTile(level, pos.south());
        }
        if (adjacent == null) {
            adjacent = this.getTile(level, pos.north());
        }
        if (adjacent == null) {
            adjacent = this.getTile(level, pos.east());
        }
        if (adjacent != null) {
            CompoundTag compound = new CompoundTag();
            adjacent.writeExtraNBT(compound);
            tile.readExtraNBT(compound);
        }
        tile.rotation = (Integer)state.getValue((Property)ROTATION);
        if (!level.isClientSide && entity instanceof Player) {
            SPacketGuiOpen.sendOpenGui((Player)entity, EnumGuiType.Border, null, pos);
        }
    }

    private TileBorder getTile(Level level, BlockPos pos) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile != null && tile instanceof TileBorder) {
            return (TileBorder)tile;
        }
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileBorder(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockBorder.createTickerHelper(type, CustomBlocks.tile_border, TileBorder::tick);
    }
}

