/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.phys.Vec3;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.wrapper.AnimalWrapper;
import noppes.npcs.api.wrapper.ArrowWrapper;
import noppes.npcs.api.wrapper.EntityItemWrapper;
import noppes.npcs.api.wrapper.EntityLivingBaseWrapper;
import noppes.npcs.api.wrapper.EntityLivingWrapper;
import noppes.npcs.api.wrapper.EntityWrapper;
import noppes.npcs.api.wrapper.MonsterWrapper;
import noppes.npcs.api.wrapper.PixelmonWrapper;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.api.wrapper.ProjectileWrapper;
import noppes.npcs.api.wrapper.ThrowableWrapper;
import noppes.npcs.api.wrapper.VillagerWrapper;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.entity.EntityProjectile;

public class WrapperEntityData {
    private static Map<Integer, WrapperEntityData> dataMap = new HashMap<Integer, WrapperEntityData>();
    public IEntity base;
    private static WrapperEntityData backup = new WrapperEntityData(null);
    private static final ResourceLocation key = new ResourceLocation("customnpcs", "entitydata");

    public WrapperEntityData(IEntity base) {
        this.base = base;
    }

    public static IEntity get(Entity entity) {
        if (entity == null || entity.position() == Vec3.ZERO) {
            return null;
        }
        WrapperEntityData data = dataMap.computeIfAbsent(entity.getId(), i -> backup);
        if (data == null || data == backup) {
            return WrapperEntityData.getData((Entity)entity).base;
        }
        return data.base;
    }

    private static WrapperEntityData getData(Entity entity) {
        if (entity == null || entity.level() == null || entity.level().isClientSide) {
            return null;
        }
        if (entity instanceof ServerPlayer) {
            return new WrapperEntityData(new PlayerWrapper<ServerPlayer>((ServerPlayer)entity));
        }
        if (PixelmonHelper.isPixelmon(entity)) {
            return new WrapperEntityData(new PixelmonWrapper<AbstractHorse>((AbstractHorse)entity));
        }
        if (entity instanceof Villager) {
            return new WrapperEntityData(new VillagerWrapper<Villager>((Villager)entity));
        }
        if (entity instanceof Animal) {
            return new WrapperEntityData(new AnimalWrapper<Animal>((Animal)entity));
        }
        if (entity instanceof Monster) {
            return new WrapperEntityData(new MonsterWrapper<Monster>((Monster)entity));
        }
        if (entity instanceof Mob) {
            return new WrapperEntityData(new EntityLivingWrapper<Mob>((Mob)entity));
        }
        if (entity instanceof LivingEntity) {
            return new WrapperEntityData(new EntityLivingBaseWrapper<LivingEntity>((LivingEntity)entity));
        }
        if (entity instanceof ItemEntity) {
            return new WrapperEntityData(new EntityItemWrapper<ItemEntity>((ItemEntity)entity));
        }
        if (entity instanceof EntityProjectile) {
            return new WrapperEntityData(new ProjectileWrapper<EntityProjectile>((EntityProjectile)entity));
        }
        if (entity instanceof ThrowableProjectile) {
            return new WrapperEntityData(new ThrowableWrapper<ThrowableProjectile>((ThrowableProjectile)entity));
        }
        if (entity instanceof AbstractArrow) {
            return new WrapperEntityData(new ArrowWrapper<AbstractArrow>((AbstractArrow)entity));
        }
        return new WrapperEntityData(new EntityWrapper<Entity>(entity));
    }
}

