/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.target;

import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.scores.PlayerTeam;
import noppes.npcs.entity.EntityNPCInterface;

public class NpcNearestAttackableTargetGoal<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    private int unseenTicks1;

    public NpcNearestAttackableTargetGoal(EntityNPCInterface npc, Class<T> c, int range, boolean b, boolean b2, Predicate<LivingEntity> selector) {
        super((Mob)npc, c, range, b, b2, selector);
        if (npc.ais.attackInvisible) {
            this.targetConditions.ignoreInvisibilityTesting();
        }
        if (!npc.ais.directLOS) {
            this.targetConditions.ignoreLineOfSight();
        }
    }

    public void start() {
        this.unseenTicks1 = 0;
        this.mob.setTarget(this.target);
        super.start();
    }

    public void stop() {
        this.mob.setTarget(null);
        this.targetMob = null;
    }

    public boolean canContinueToUse() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity == null) {
            livingentity = this.targetMob;
        }
        if (livingentity == null) {
            return false;
        }
        if (!this.mob.canAttack(livingentity)) {
            return false;
        }
        PlayerTeam team = this.mob.getTeam();
        PlayerTeam team1 = livingentity.getTeam();
        if (team != null && team1 == team) {
            return false;
        }
        double d0 = this.getFollowDistance();
        if (this.mob.distanceToSqr((Entity)livingentity) > d0 * d0) {
            return false;
        }
        if (this.mustSee) {
            if (this.mob.getSensing().hasLineOfSight((Entity)livingentity)) {
                this.unseenTicks1 = 0;
            } else if (++this.unseenTicks1 > NpcNearestAttackableTargetGoal.reducedTickDelay((int)this.unseenMemoryTicks)) {
                return false;
            }
        }
        this.mob.setTarget(livingentity);
        return true;
    }
}

