/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAISprintToTarget
extends Goal {
    private EntityNPCInterface npc;

    public EntityAISprintToTarget(EntityNPCInterface par1EntityLiving) {
        this.npc = par1EntityLiving;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity runTarget = this.npc.getTarget();
        if (runTarget == null || this.npc.getNavigation().isDone()) {
            return false;
        }
        switch (this.npc.ais.onAttack) {
            case 0: {
                return !this.npc.isInRange((Entity)runTarget, 8.0) ? this.npc.onGround() : false;
            }
            case 2: {
                return this.npc.isInRange((Entity)runTarget, 7.0) ? this.npc.onGround() : false;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        Vec3 mo = this.npc.getDeltaMovement();
        return this.npc.isAlive() && this.npc.onGround() && this.npc.hurtTime <= 0 && mo.x != 0.0 && mo.z != 0.0;
    }

    public void start() {
        this.npc.setSprinting(true);
    }

    public void stop() {
        this.npc.setSprinting(false);
    }
}

