/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerSkinData;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketSyncSkin;

@EventBusSubscriber(modid="customnpcs")
public class SkinEventHandler {
    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        if (PlayerSkinData.needsAnyResync()) {
            for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
                PlayerData playerData = PlayerData.get((Player)player);
                if (!playerData.skinData.isActive() || !playerData.skinData.hasChanged()) continue;
                Packets.sendAll(new PacketSyncSkin(playerData.playername, playerData.skinData));
                playerData.skinData.markSynced();
            }
            PlayerSkinData.resyncPerformed();
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        PlayerData playerData = PlayerData.get((Player)player);
        if (playerData.skinData.isActive()) {
            Packets.sendAll(new PacketSyncSkin(playerData.playername, playerData.skinData));
        }
        for (ServerPlayer otherPlayer : player.server.getPlayerList().getPlayers()) {
            PlayerData otherPlayerData = PlayerData.get((Player)otherPlayer);
            if (!otherPlayerData.skinData.isActive()) continue;
            Packets.send(player, new PacketSyncSkin(otherPlayerData.playername, otherPlayerData.skinData));
        }
    }
}

