/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.key;

import com.google.gson.JsonElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.HolderLookup;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.field.ConfigField;
import team.creative.creativecore.common.config.field.ConfigFieldTyped;
import team.creative.creativecore.common.config.field.ConfigFieldWrapper;
import team.creative.creativecore.common.config.gui.GuiConfigSubControl;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.holder.ConfigHolderObject;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.key.ConfigKeyHolder;
import team.creative.creativecore.common.config.key.ConfigKeyType;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;

public abstract class ConfigKey {
    public final String name;
    public final ConfigSynchronization synchronization;
    public final boolean requiresRestart;
    public boolean forceSynchronization;
    protected final ConfigField field;

    public static ConfigKey of(ICreativeConfigHolder parentHolder, Field field, String name, Object defaultValue, ConfigSynchronization sync, boolean requiresRestart, Object parent) {
        return ConfigKey.of(parentHolder, new ConfigFieldWrapper(parent, field), name, defaultValue, sync, requiresRestart);
    }

    public static ConfigKey of(ICreativeConfigHolder parent, ConfigField field, String name, Object defaultValue, ConfigSynchronization sync, boolean requiresRestart) {
        if (ConfigTypeConveration.has(field.getType())) {
            return new ConfigKeyType(field, name, defaultValue, sync, requiresRestart);
        }
        return new ConfigKeyHolder(new ConfigHolderObject(parent, sync, name, defaultValue), field, name, sync, requiresRestart);
    }

    public static ConfigKey ofGenericType(ConfigKey key, Side side) {
        Class clazz;
        Type type = ConfigTypeConveration.getGenericType(key);
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            clazz = (Class)p.getRawType();
        } else {
            clazz = (Class)type;
        }
        Class clazz2 = clazz;
        ConfigFieldTyped field = new ConfigFieldTyped(null, type, clazz2);
        return ConfigKey.ofType(key, field, side);
    }

    public static ConfigKey ofArrayType(ConfigKey key, Side side) {
        Type type = ConfigTypeConveration.getGenericType(key);
        Class<?> clazz = key.field().getType().getComponentType();
        ConfigFieldTyped field = new ConfigFieldTyped(null, type, clazz);
        return ConfigKey.ofType(key, field, side);
    }

    public static ConfigKey ofType(ConfigKey key, ConfigField field, Side side) {
        field.set(ConfigTypeConveration.createObject(field));
        if (ConfigTypeConveration.has(field.getType())) {
            return new ConfigKeyType(field, "", ConfigTypeConveration.createObject(field), ConfigSynchronization.UNIVERSAL, false);
        }
        return new ConfigKeyHolder(ConfigHolderObject.createUnrelated(side, field.get()), field, "", ConfigSynchronization.UNIVERSAL, false);
    }

    public ConfigKey(ConfigField field, String name, ConfigSynchronization synchronization, boolean requiresRestart) {
        this.synchronization = synchronization;
        this.requiresRestart = requiresRestart;
        this.name = name;
        this.field = field;
    }

    public Object get() {
        return this.field.get();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConfigKey) {
            ConfigKey c = (ConfigKey)obj;
            return c.name.equals(this.name);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    protected boolean checkEqual(Object one, Object two, Side side) {
        return one.equals(two);
    }

    public abstract boolean isFolder();

    public abstract ICreativeConfigHolder holder();

    public abstract ConfigTypeConveration converation();

    public boolean is(Side side) {
        if (this.isFolder()) {
            return this.synchronization.useFolder(this.forceSynchronization, side);
        }
        return this.synchronization.useValue(this.forceSynchronization, side);
    }

    public boolean isWithoutForce(Side side) {
        if (this.isFolder()) {
            return this.synchronization.useFolder(false, side);
        }
        return this.synchronization.useValue(false, side);
    }

    public abstract void triggerConfigured(Side var1);

    public abstract boolean isDefault(Side var1);

    public abstract boolean isDefault(Object var1, Side var2);

    public abstract void restoreDefault(Side var1, boolean var2);

    public abstract void forceValue(Object var1, Side var2);

    public abstract void read(HolderLookup.Provider var1, boolean var2, boolean var3, JsonElement var4, Side var5);

    public abstract JsonElement write(HolderLookup.Provider var1, boolean var2, boolean var3, Side var4);

    public abstract Object copy(HolderLookup.Provider var1, Side var2);

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public abstract GuiConfigSubControl create(IGuiConfigParent var1, String var2, Side var3);

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public abstract void load(IGuiConfigParent var1, GuiConfigSubControl var2, Side var3);

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public abstract void save(GuiConfigSubControl var1, IGuiConfigParent var2, Side var3);

    public ConfigField field() {
        return this.field;
    }
}

