/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.utils;

import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import fr.iglee42.createcasing.config.ModConfigs;
import fr.iglee42.createcasing.utils.EncasableBlocks;
import fr.iglee42.createcasing.utils.WoodBlocks;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="createcasing")
public class ItemChangeBlockManager {
    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getEntity().level();
        if (event.getItemStack().isEmpty()) {
            return;
        }
        if (level.getBlockState(event.getPos()).isAir()) {
            return;
        }
        BlockState state = level.getBlockState(event.getPos());
        if (EncasableBlocks.hasBlocksForCasing(event.getItemStack().getItem()) && ((Boolean)ModConfigs.common().kinetics.casingBlockSwappable.get()).booleanValue()) {
            EncasableBlocks casingSet = EncasableBlocks.getBlockByCasing(event.getItemStack().getItem());
            if (casingSet.isInSet(state)) {
                return;
            }
            if (EncasableBlocks.isGearbox(state)) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, casingSet.getGearbox().getDefaultState());
            }
            if (EncasableBlocks.isMixer(state)) {
                ItemChangeBlockManager.changeBlock(event, state, level, casingSet.getMixer().getDefaultState());
            }
            if (EncasableBlocks.isPress(state)) {
                ItemChangeBlockManager.changeHorizontalDirectionBlock(event, state, level, casingSet.getPress().getDefaultState());
            }
            if (EncasableBlocks.isDepot(state) && event.getFace() != Direction.UP) {
                ItemChangeBlockManager.changeBlock(event, state, level, casingSet.getDepot().getDefaultState());
            }
            if (EncasableBlocks.isChainDrive(state)) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, casingSet.getChainDrive().getDefaultState());
            }
            if (EncasableBlocks.isAdjustableChainDrive(state)) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, casingSet.getAdjustableChainDrive().getDefaultState());
            }
        }
        if (WoodBlocks.hasBlocksForItem(event.getItemStack().getItem()) && ((Boolean)ModConfigs.common().kinetics.shaftCogwheelsSwappable.get()).booleanValue()) {
            WoodBlocks woodSet = WoodBlocks.getBlockByItem(event.getItemStack().getItem());
            if (woodSet.isInSet(state)) {
                return;
            }
            if (WoodBlocks.isShaft(state) && woodSet.hasShaft()) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, woodSet.getShaft().getDefaultState());
            }
            if (WoodBlocks.isCogwheel(state) && woodSet.hasCogwheel()) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, woodSet.getCogwheel().getDefaultState());
            }
            if (WoodBlocks.isLargeCogwheel(state) && woodSet.hasLargeCogwheel()) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, woodSet.getLargeCogwheel().getDefaultState());
            }
        }
    }

    private static void changeBlock(PlayerInteractEvent.RightClickBlock event, BlockState state, Level level, BlockState newBlock) {
        level.setBlockAndUpdate(event.getPos(), newBlock);
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    private static void changeHorizontalDirectionBlock(PlayerInteractEvent.RightClickBlock event, BlockState state, Level level, BlockState newBlock) {
        if (!(state.getBlock() instanceof HorizontalKineticBlock)) {
            return;
        }
        Direction facing = (Direction)state.getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        ItemChangeBlockManager.changeBlock(event, state, level, (BlockState)newBlock.setValue(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)facing));
    }

    private static void changeAxisBlock(PlayerInteractEvent.RightClickBlock event, BlockState state, Level level, BlockState newBlock) {
        if (!(state.getBlock() instanceof RotatedPillarKineticBlock)) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)RotatedPillarKineticBlock.AXIS);
        ItemChangeBlockManager.changeBlock(event, state, level, (BlockState)newBlock.setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)axis));
    }
}

