/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.integration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.CircleMarker;
import org.dynmap.markers.MarkerDescription;
import org.dynmap.markers.MarkerSet;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.shape.AbstractEllipse;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunkyborder.integration.AbstractMapIntegration;

public class DynmapIntegration
extends AbstractMapIntegration {
    private final MarkerSet markerSet;
    private final Map<String, MarkerDescription> markers;

    public DynmapIntegration(DynmapCommonAPI dynmapAPI) {
        this.markerSet = dynmapAPI.getMarkerAPI().createMarkerSet("chunky.markerset", this.label, null, false);
        this.markers = new HashMap<String, MarkerDescription>();
    }

    @Override
    public void addShapeMarker(World world, Shape shape) {
        this.removeShapeMarker(world);
        String dynmapWorldName = this.adaptWorldName(world.getName());
        if (shape instanceof AbstractPolygon) {
            AbstractPolygon polygon = (AbstractPolygon)shape;
            List points = polygon.points();
            int size = points.size();
            double[] pointsX = new double[size];
            double[] pointsZ = new double[size];
            for (int i = 0; i < size; ++i) {
                Vector2 point = (Vector2)points.get(i);
                pointsX[i] = point.getX();
                pointsZ[i] = point.getZ();
            }
            AreaMarker marker = this.markerSet.createAreaMarker(null, this.label, false, dynmapWorldName, pointsX, pointsZ, false);
            marker.setLineStyle(this.weight, 1.0, this.color);
            marker.setFillStyle(0.0, 0);
            this.markers.put(world.getName(), (MarkerDescription)marker);
        } else if (shape instanceof AbstractEllipse) {
            AbstractEllipse ellipse = (AbstractEllipse)shape;
            Vector2 center = ellipse.center();
            Vector2 radii = ellipse.radii();
            CircleMarker marker = this.markerSet.createCircleMarker(null, this.label, false, dynmapWorldName, center.getX(), (double)world.getSeaLevel(), center.getZ(), radii.getX(), radii.getZ(), false);
            marker.setLineStyle(this.weight, 1.0, this.color);
            marker.setFillStyle(0.0, 0);
            this.markers.put(world.getName(), (MarkerDescription)marker);
        }
    }

    @Override
    public void removeShapeMarker(World world) {
        MarkerDescription marker = this.markers.remove(world.getName());
        if (marker != null) {
            marker.deleteMarker();
        }
    }

    @Override
    public void removeAllShapeMarkers() {
        if (this.markerSet != null) {
            this.markerSet.deleteMarkerSet();
        }
        this.markers.clear();
    }

    @Override
    public void setOptions(String label, String color, boolean hideByDefault, int priority, int weight) {
        super.setOptions(label, color, hideByDefault, priority, weight);
        if (this.markerSet != null) {
            this.markerSet.setHideByDefault(hideByDefault);
            this.markerSet.setLayerPriority(priority);
        }
    }

    private String adaptWorldName(String worldName) {
        return switch (worldName) {
            case "minecraft:overworld" -> "world";
            case "minecraft:the_nether" -> "DIM-1";
            case "minecraft:the_end" -> "DIM1";
            default -> worldName.indexOf(58) < 0 ? worldName : worldName.replace(':', '_');
        };
    }
}

