/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.util.Translator;
import org.popcraft.chunkyborder.BorderData;
import org.popcraft.chunkyborder.BorderWrapType;
import org.popcraft.chunkyborder.ChunkyBorder;

public class WrapCommand
implements ChunkyCommand {
    private final ChunkyBorder chunkyBorder;

    public WrapCommand(ChunkyBorder chunkyBorder) {
        this.chunkyBorder = chunkyBorder;
    }

    public void execute(Sender sender, CommandArguments arguments) {
        Selection selection;
        World world;
        Map<String, BorderData> borders = this.chunkyBorder.getBorders();
        BorderData currentBorder = borders.get((world = (selection = this.chunkyBorder.getChunky().getSelection().build()).world()).getName());
        if (currentBorder != null) {
            BorderWrapType wrap = arguments.next().map(BorderWrapType::fromString).orElse(BorderWrapType.NONE);
            currentBorder.setWrap(wrap.toString());
            sender.sendMessagePrefixed("format_border_wrap", new Object[]{Translator.translate((String)"wrap_%s".formatted(wrap.toString().toLowerCase()), (Object[])new Object[0]), world.getName()});
            this.chunkyBorder.saveBorders();
        } else {
            sender.sendMessagePrefixed("format_border_no_border", new Object[]{world.getName()});
        }
    }

    public List<String> suggestions(CommandArguments commandArguments) {
        if (commandArguments.size() == 2) {
            ArrayList<String> suggestions = new ArrayList<String>();
            for (BorderWrapType wrapType : BorderWrapType.values()) {
                suggestions.add(wrapType.name().toLowerCase());
            }
            return suggestions;
        }
        return List.of();
    }
}

