/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.neoforge;

import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.DownloadQueue;
import me.chrr.camerapture.config.Config;
import me.chrr.camerapture.entity.PictureFrameEntity;
import me.chrr.camerapture.item.AlbumItem;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.neoforge.NeoForgeNetworkAdapter;
import me.chrr.camerapture.net.clientbound.DownloadPartialPicturePacket;
import me.chrr.camerapture.net.clientbound.PictureErrorPacket;
import me.chrr.camerapture.net.clientbound.RequestUploadPacket;
import me.chrr.camerapture.net.clientbound.SyncConfigPacket;
import me.chrr.camerapture.net.serverbound.NewPicturePacket;
import me.chrr.camerapture.net.serverbound.RequestDownloadPacket;
import me.chrr.camerapture.net.serverbound.UploadPartialPicturePacket;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="camerapture")
public class CameraptureNeoForge {
    public CameraptureNeoForge(IEventBus modBus) {
        modBus.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new ServerEvents());
    }

    @SubscribeEvent
    public void registerContent(RegisterEvent event) {
        Camerapture.CONFIG_MANAGER.load();
        event.register(Registries.ITEM, registry -> registry.register(CameraItem.KEY, (Object)Camerapture.CAMERA));
        event.register(Registries.SOUND_EVENT, registry -> registry.register(Camerapture.id("camera_shutter"), (Object)Camerapture.CAMERA_SHUTTER));
        event.register(Registries.CUSTOM_STAT, registry -> {
            registry.register(Camerapture.PICTURES_TAKEN, (Object)Camerapture.PICTURES_TAKEN);
            Stats.CUSTOM.get((Object)Camerapture.PICTURES_TAKEN, StatFormatter.DEFAULT);
        });
        event.register(Registries.ITEM, registry -> registry.register(PictureItem.KEY, (Object)Camerapture.PICTURE));
        event.register(Registries.RECIPE_SERIALIZER, registry -> registry.register(Camerapture.id("picture_cloning"), Camerapture.PICTURE_CLONING));
        event.register(Registries.ITEM, registry -> registry.register(AlbumItem.KEY, (Object)Camerapture.ALBUM));
        event.register(Registries.MENU, registry -> registry.register(Camerapture.id("album"), Camerapture.ALBUM_SCREEN_HANDLER));
        event.register(Registries.MENU, registry -> registry.register(Camerapture.id("album_lectern"), Camerapture.ALBUM_LECTERN_SCREEN_HANDLER));
        event.register(Registries.ENTITY_TYPE, registry -> registry.register(PictureFrameEntity.KEY, Camerapture.PICTURE_FRAME));
        event.register(Registries.MENU, registry -> registry.register(Camerapture.id("picture_frame"), Camerapture.PICTURE_FRAME_SCREEN_HANDLER));
        event.register(Registries.DATA_COMPONENT_TYPE, registry -> registry.register(Camerapture.id("picture_data"), Camerapture.PICTURE_DATA));
        event.register(Registries.DATA_COMPONENT_TYPE, registry -> registry.register(Camerapture.id("camera_active"), Camerapture.CAMERA_ACTIVE));
    }

    @SubscribeEvent
    public void registerPackets(RegisterPayloadHandlersEvent event) {
        NeoForgeNetworkAdapter networkAdapter = (NeoForgeNetworkAdapter)Camerapture.NETWORK;
        PayloadRegistrar registrar = event.registrar("1");
        networkAdapter.registerServerBound(registrar, NewPicturePacket.class, NewPicturePacket.NET_CODEC);
        networkAdapter.registerServerBound(registrar, RequestDownloadPacket.class, RequestDownloadPacket.NET_CODEC);
        networkAdapter.registerServerBound(registrar, UploadPartialPicturePacket.class, UploadPartialPicturePacket.NET_CODEC);
        networkAdapter.registerClientBound(registrar, PictureErrorPacket.class, PictureErrorPacket.NET_CODEC);
        networkAdapter.registerClientBound(registrar, RequestUploadPacket.class, RequestUploadPacket.NET_CODEC);
        networkAdapter.registerClientBound(registrar, SyncConfigPacket.class, SyncConfigPacket.NET_CODEC);
        networkAdapter.registerClientBound(registrar, DownloadPartialPicturePacket.class, DownloadPartialPicturePacket.NET_CODEC);
        Camerapture.registerPacketHandlers();
    }

    @SubscribeEvent
    public void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept((ItemLike)Camerapture.CAMERA);
            event.accept((ItemLike)Camerapture.ALBUM);
        }
    }

    private static class ServerEvents {
        private ServerEvents() {
        }

        @SubscribeEvent
        public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Config config = Camerapture.CONFIG_MANAGER.getConfig();
            Camerapture.NETWORK.sendToClient((ServerPlayer)event.getEntity(), new SyncConfigPacket(config.server.maxImageBytes, config.server.maxImageResolution, config.server.allowUploading));
        }

        @SubscribeEvent
        public void onServerStarted(ServerStartedEvent event) {
            DownloadQueue.getInstance().start(Camerapture.CONFIG_MANAGER.getConfig().server.msPerPicture);
        }

        @SubscribeEvent
        public void onServerStopping(ServerStoppingEvent event) {
            DownloadQueue.getInstance().stop();
        }
    }
}

