/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.mixin;

import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.ItemStackComponentizationFix;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStackComponentizationFix.class})
public class ItemStackComponentizationFixMixin {
    @Inject(method={"fixItemStack(Lnet/minecraft/util/datafix/fixes/ItemStackComponentizationFix$ItemStackData;Lcom/mojang/serialization/Dynamic;)V"}, at={@At(value="TAIL")})
    private static void fixStack(ItemStackComponentizationFix.ItemStackData data, Dynamic<?> dynamic, CallbackInfo ci) {
        if (data.is("camerapture:picture")) {
            ItemStackComponentizationFixMixin.camerapture$fixPicture(data, dynamic);
        }
        if (data.is("camerapture:album")) {
            ItemStackComponentizationFixMixin.camerapture$fixAlbum(data, dynamic);
        }
        if (data.is("camerapture:camera")) {
            data.removeTag("active");
        }
    }

    @Unique
    private static void camerapture$fixPicture(ItemStackComponentizationFix.ItemStackData data, Dynamic<?> dynamic) {
        Optional uuid = data.removeTag("uuid").result();
        if (uuid.isPresent()) {
            String creator = data.removeTag("creator").asString("");
            long timestamp = data.removeTag("timestamp").asLong(0L);
            data.setComponent("camerapture:picture_data", dynamic.emptyMap().set("id", (Dynamic)uuid.get()).set("creator", dynamic.createString(creator)).set("timestamp", dynamic.createLong(timestamp)));
        }
    }

    @Unique
    private static void camerapture$fixAlbum(ItemStackComponentizationFix.ItemStackData data, Dynamic<?> dynamic) {
        List list = data.removeTag("Items").asList(itemsDynamic -> itemsDynamic.emptyMap().set("slot", itemsDynamic.createInt((int)itemsDynamic.get("Slot").asByte((byte)0))).set("item", itemsDynamic.remove("Slot")));
        if (!list.isEmpty()) {
            data.setComponent("minecraft:container", dynamic.createList(list.stream()));
        }
    }
}

