/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

import java.util.ArrayList;
import java.util.List;
import juuxel.adorn.util.CollectionUtil;
import juuxel.adorn.util.NbtConvertible;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import org.jetbrains.annotations.Nullable;

public class InventoryComponent
implements Container,
NbtConvertible {
    private final int size;
    private final List<ContainerListener> listeners = new ArrayList<ContainerListener>();
    private final NonNullList<ItemStack> items;

    public InventoryComponent(int size) {
        this.size = size;
        this.items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    private InventoryComponent(NonNullList<ItemStack> items) {
        this(items.size());
        for (int i = 0; i < items.size(); ++i) {
            this.items.set(i, (Object)((ItemStack)items.get(i)));
        }
    }

    public InventoryComponent copy() {
        return new InventoryComponent(this.items);
    }

    public boolean canExtract(ItemStack stack) {
        int remainingAmount = stack.getCount();
        for (ItemStack invStack : this.items) {
            if (!ItemStack.isSameItem((ItemStack)invStack, (ItemStack)stack) || (remainingAmount -= invStack.getCount()) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean tryExtract(ItemStack stack) {
        int remainingAmount = stack.getCount();
        for (ItemStack invStack : this.items) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)invStack, (ItemStack)stack)) continue;
            int invStackAmount = invStack.getCount();
            invStack.shrink(Math.min(invStackAmount, remainingAmount));
            if ((remainingAmount -= invStackAmount) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean canInsert(ItemStack stack) {
        int remainingAmount = stack.getCount();
        for (ItemStack invStack : this.items) {
            int insertionAmount;
            if (!(ItemStack.isSameItemSameComponents((ItemStack)invStack, (ItemStack)stack) && invStack.getCount() < invStack.getMaxStackSize() ? (remainingAmount -= (insertionAmount = Math.min(invStack.getMaxStackSize() - invStack.getCount(), remainingAmount))) <= 0 : invStack.isEmpty())) continue;
            return true;
        }
        return false;
    }

    public boolean tryInsert(ItemStack stack) {
        int remainingAmount = stack.getCount();
        for (int slot = 0; slot < this.items.size(); ++slot) {
            ItemStack invStack = (ItemStack)this.items.get(slot);
            if (ItemStack.isSameItemSameComponents((ItemStack)invStack, (ItemStack)stack) && invStack.getCount() < invStack.getMaxStackSize()) {
                int insertionAmount = Math.min(invStack.getMaxStackSize() - invStack.getCount(), remainingAmount);
                invStack.grow(insertionAmount);
                if ((remainingAmount -= insertionAmount) > 0) continue;
                return true;
            }
            if (!invStack.isEmpty()) continue;
            this.items.set(slot, (Object)stack.copy());
            return true;
        }
        return false;
    }

    public int getCountWithComponents(ItemStack stack) {
        return CollectionUtil.sumOf(this.items, it -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)it) ? it.getCount() : 0);
    }

    @Override
    public CompoundTag writeNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.items, (HolderLookup.Provider)registries);
        return nbt;
    }

    @Override
    public void readNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.items, (HolderLookup.Provider)registries);
    }

    public ItemContainerContents toContainerComponent() {
        return ItemContainerContents.fromItems(this.items);
    }

    public void copyFrom(@Nullable ItemContainerContents component) {
        if (component == null) {
            return;
        }
        component.copyInto(this.items);
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public void setItem(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.items, (int)slot);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public int getContainerSize() {
        return this.size;
    }

    public ItemStack removeItem(int slot, int count) {
        ItemStack stack = ContainerHelper.removeItem(this.items, (int)slot, (int)count);
        if (!stack.isEmpty()) {
            this.setChanged();
        }
        return stack;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setChanged() {
        for (ContainerListener listener : this.listeners) {
            listener.containerChanged((Container)this);
        }
    }

    public void addListener(ContainerListener listener) {
        this.listeners.add(listener);
    }
}

