/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

import juuxel.adorn.util.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.slf4j.Logger;

public final class AdornUtil {
    private static final Logger LOGGER = Logging.logger();

    public static MutableComponent toTextWithCount(ItemStack stack) {
        return Component.translatable((String)"text.adorn.item_stack_with_count", (Object[])new Object[]{stack.getCount(), stack.getDisplayName()});
    }

    public static BlockBehaviour.Properties copySettingsSafely(Block block) {
        BlockBehaviour.Properties settings = BlockBehaviour.Properties.of();
        AdornUtil.caughtProperty(block, "mapColor", () -> settings.mapColor(block.defaultMapColor()));
        AdornUtil.caughtProperty(block, "luminance", () -> {
            int luminance = block.defaultBlockState().getLightEmission();
            settings.lightLevel(state -> luminance);
        });
        AdornUtil.caughtProperty(block, "hardness", () -> settings.destroyTime(block.defaultBlockState().getDestroySpeed(null, null)));
        AdornUtil.caughtProperty(block, "resistance", () -> settings.explosionResistance(block.getExplosionResistance()));
        AdornUtil.caughtProperty(block, "velocityMultiplier", () -> settings.speedFactor(block.getSpeedFactor()));
        AdornUtil.caughtProperty(block, "jumpVelocityMultiplier", () -> settings.jumpFactor(block.getJumpFactor()));
        AdornUtil.caughtProperty(block, "slipperiness", () -> settings.friction(block.getFriction()));
        AdornUtil.caughtProperty(block, "soundGroup", () -> settings.sound(block.defaultBlockState().getSoundType()));
        AdornUtil.caughtProperty(block, "burnable", () -> {
            if (block.defaultBlockState().ignitedByLava()) {
                settings.ignitedByLava();
            }
        });
        return settings;
    }

    private static void caughtProperty(Block block, String name, Runnable fn) {
        try {
            fn.run();
        }
        catch (Exception e) {
            LOGGER.warn("[Adorn] Could not get block property {} from {}", new Object[]{name, BuiltInRegistries.BLOCK.getKey((Object)block), e});
        }
    }

    public static Direction.Axis turnHorizontally(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> Direction.Axis.Z;
            case Direction.Axis.Z -> Direction.Axis.X;
            case Direction.Axis.Y -> Direction.Axis.Y;
        };
    }

    public static ContainerLevelAccess menuContextOf(BlockEntity blockEntity) {
        return ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
    }
}

