/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.trading;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import juuxel.adorn.trading.TradeInventory;
import juuxel.adorn.util.NbtConvertible;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class Trade
implements NbtConvertible,
TooltipComponent {
    public static final Codec<Trade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("selling").forGetter(Trade::getSelling), (App)ItemStack.OPTIONAL_CODEC.fieldOf("price").forGetter(Trade::getPrice)).apply((Applicative)instance, Trade::new));
    public static final String NBT_SELLING = "Selling";
    public static final String NBT_PRICE = "Price";
    private ItemStack selling;
    private ItemStack price;
    private final List<TradeListener> listeners = new ArrayList<TradeListener>();

    public Trade(ItemStack selling, ItemStack price) {
        this.selling = selling;
        this.price = price;
    }

    public ItemStack getSelling() {
        return this.selling;
    }

    public void setSelling(ItemStack selling) {
        this.selling = selling;
    }

    public ItemStack getPrice() {
        return this.price;
    }

    public void setPrice(ItemStack price) {
        this.price = price;
    }

    public boolean isEmpty() {
        return this.selling.isEmpty() || this.price.isEmpty();
    }

    public boolean isFullyEmpty() {
        return this.selling.isEmpty() && this.price.isEmpty();
    }

    @Override
    public void readNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        this.selling = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound(NBT_SELLING));
        this.price = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound(NBT_PRICE));
    }

    @Override
    public CompoundTag writeNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.put(NBT_SELLING, this.selling.saveOptional(registries));
        nbt.put(NBT_PRICE, this.price.saveOptional(registries));
        return nbt;
    }

    public void copyFrom(@Nullable Trade trade) {
        if (trade == null) {
            return;
        }
        this.selling = trade.selling.copy();
        this.price = trade.price.copy();
    }

    public void addListener(TradeListener listener) {
        this.listeners.add(listener);
    }

    public void callListeners() {
        for (TradeListener listener : this.listeners) {
            listener.onTradeChanged(this);
        }
    }

    public TradeInventory createInventory() {
        return new TradeInventory(this);
    }

    public int hashCode() {
        return Objects.hash(this.selling, this.price);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Trade)) {
            return false;
        }
        Trade other = (Trade)obj;
        return this.selling.equals(other.selling) && this.price.equals(other.price);
    }

    public static Trade empty() {
        return new Trade(ItemStack.EMPTY, ItemStack.EMPTY);
    }

    public static Trade fromNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        Trade trade = Trade.empty();
        trade.readNbt(nbt, registries);
        return trade;
    }

    @FunctionalInterface
    public static interface TradeListener {
        public void onTradeChanged(Trade var1);
    }
}

