/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import juuxel.adorn.recipe.AdornRecipeSerializers;
import juuxel.adorn.recipe.BrewerInput;
import juuxel.adorn.recipe.BrewingRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public record ItemBrewingRecipe(Ingredient firstIngredient, Ingredient secondIngredient, ItemStack result) implements BrewingRecipe
{
    public static final MapCodec<ItemBrewingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("first_ingredient").forGetter(ItemBrewingRecipe::firstIngredient), (App)Ingredient.CODEC.optionalFieldOf("second_ingredient", (Object)Ingredient.of()).forGetter(ItemBrewingRecipe::secondIngredient), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(ItemBrewingRecipe::result)).apply((Applicative)builder, ItemBrewingRecipe::new));

    public boolean matches(BrewerInput input, Level world) {
        return ItemBrewingRecipe.matches(input, 1, this.firstIngredient) && ItemBrewingRecipe.matches(input, 2, this.secondIngredient) || ItemBrewingRecipe.matches(input, 2, this.firstIngredient) && ItemBrewingRecipe.matches(input, 1, this.secondIngredient);
    }

    private static boolean matches(BrewerInput input, int index, Ingredient ingredient) {
        return ingredient.test(input.getItem(index));
    }

    public ItemStack craft(BrewerInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AdornRecipeSerializers.BREWING.get();
    }

    public static final class Serializer
    implements RecipeSerializer<ItemBrewingRecipe> {
        private static final StreamCodec<RegistryFriendlyByteBuf, ItemBrewingRecipe> PACKET_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public MapCodec<ItemBrewingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ItemBrewingRecipe> streamCodec() {
            return PACKET_CODEC;
        }

        private static ItemBrewingRecipe read(RegistryFriendlyByteBuf buf) {
            Ingredient first = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            Ingredient second = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            return new ItemBrewingRecipe(first, second, output);
        }

        private static void write(RegistryFriendlyByteBuf buf, ItemBrewingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.firstIngredient);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.secondIngredient);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
        }
    }
}

