/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import juuxel.adorn.fluid.FluidIngredient;
import juuxel.adorn.recipe.AdornRecipeSerializers;
import juuxel.adorn.recipe.BrewerInput;
import juuxel.adorn.recipe.BrewingRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public record FluidBrewingRecipe(Ingredient firstIngredient, Ingredient secondIngredient, FluidIngredient fluid, ItemStack result) implements BrewingRecipe
{
    public static final MapCodec<FluidBrewingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("first_ingredient").forGetter(FluidBrewingRecipe::firstIngredient), (App)Ingredient.CODEC.optionalFieldOf("second_ingredient", (Object)Ingredient.of()).forGetter(FluidBrewingRecipe::secondIngredient), (App)FluidIngredient.CODEC.fieldOf("fluid").forGetter(FluidBrewingRecipe::fluid), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(FluidBrewingRecipe::result)).apply((Applicative)builder, FluidBrewingRecipe::new));

    public boolean matches(BrewerInput input, Level world) {
        boolean itemsMatch = FluidBrewingRecipe.matches(input, 1, this.firstIngredient) && FluidBrewingRecipe.matches(input, 2, this.secondIngredient) || FluidBrewingRecipe.matches(input, 2, this.firstIngredient) && FluidBrewingRecipe.matches(input, 1, this.firstIngredient);
        return itemsMatch && input.getFluidReference().matches(this.fluid);
    }

    private static boolean matches(BrewerInput input, int index, Ingredient ingredient) {
        return ingredient.test(input.getItem(index));
    }

    public ItemStack craft(BrewerInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AdornRecipeSerializers.BREWING_FROM_FLUID.get();
    }

    public static final class Serializer
    implements RecipeSerializer<FluidBrewingRecipe> {
        private static final StreamCodec<RegistryFriendlyByteBuf, FluidBrewingRecipe> PACKET_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, FluidBrewingRecipe::firstIngredient, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, FluidBrewingRecipe::secondIngredient, FluidIngredient.PACKET_CODEC, FluidBrewingRecipe::fluid, (StreamCodec)ItemStack.STREAM_CODEC, FluidBrewingRecipe::result, FluidBrewingRecipe::new);

        public MapCodec<FluidBrewingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FluidBrewingRecipe> streamCodec() {
            return PACKET_CODEC;
        }
    }
}

