/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.registrar;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import juuxel.adorn.lib.registry.Registered;
import juuxel.adorn.platform.forge.registrar.ForgeRegistrar;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class DeferredRegistrar<T>
implements ForgeRegistrar<T> {
    private final DeferredRegister<T> register;
    private final List<DeferredHolder<T, ? extends T>> objects = new ArrayList<DeferredHolder<T, ? extends T>>();

    public DeferredRegistrar(ResourceKey<? extends Registry<T>> registry) {
        this.register = DeferredRegister.create(registry, (String)"adorn");
    }

    @Override
    public void hook(IEventBus modBus) {
        this.register.register(modBus);
    }

    @Override
    public <U extends T> Registered.WithKey<T, U> register(String id, Supplier<? extends U> provider) {
        final DeferredHolder registryObject = this.register.register(id, provider);
        this.objects.add(registryObject);
        return new Registered.WithKey<T, U>(this){

            @Override
            public ResourceKey<T> key() {
                return registryObject.getKey();
            }

            @Override
            public U get() {
                return registryObject.get();
            }
        };
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform(this.objects.iterator(), DeferredHolder::get);
    }
}

