/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.mixin;

import juuxel.adorn.block.SofaBlock;
import juuxel.adorn.lib.AdornGameRules;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
abstract class PlayerEntityMixin
extends LivingEntity {
    private PlayerEntityMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"isSleepingLongEnough()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void onCanResetTimeBySleeping(CallbackInfoReturnable<Boolean> info) {
        Level world = this.level();
        boolean skipNight = world.getGameRules().getBoolean(AdornGameRules.SKIP_NIGHT_ON_SOFAS);
        if (info.getReturnValueZ() && (!skipNight || world.isDay()) && this.getSleepingPos().map(pos -> world.getBlockState(pos).getBlock() instanceof SofaBlock).orElse(false).booleanValue()) {
            info.setReturnValue((Object)false);
        }
    }
}

