/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.compat;

import java.util.Map;
import juuxel.adorn.block.variant.BlockVariantSets;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.platform.forge.compat.ArchitectsPaletteCompat;
import juuxel.adorn.platform.forge.compat.BiomeMakeoverCompat;
import juuxel.adorn.platform.forge.compat.BiomesOPlentyCompat;
import juuxel.adorn.platform.forge.compat.BygCompat;
import juuxel.adorn.platform.forge.compat.EcologicsCompat;
import juuxel.adorn.platform.forge.registrar.ForgeRegistrar;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;

public final class Compat {
    public static void init(IEventBus modBus) {
        Compat.ifModLoaded("biomemakeover", () -> BlockVariantSets.add(new BiomeMakeoverCompat()));
        Compat.ifModLoaded("biomesoplenty", () -> BlockVariantSets.add(new BiomesOPlentyCompat()));
        Compat.ifModLoaded("byg", () -> BlockVariantSets.add(new BygCompat()));
        Compat.ifModLoaded("ecologics", () -> BlockVariantSets.add(new EcologicsCompat()));
        Compat.ifModLoaded("architects_palette", () -> BlockVariantSets.add(new ArchitectsPaletteCompat()));
        ((ForgeRegistrar)BlockVariantSets.BLOCKS).hook(modBus);
        ((ForgeRegistrar)BlockVariantSets.ITEMS).hook(modBus);
    }

    public static boolean isCompatEnabled(String mod) {
        Map<String, Boolean> compatMap = ConfigManager.config().compat;
        if (!compatMap.containsKey(mod)) {
            compatMap.put(mod, true);
            ConfigManager.get().save();
            return true;
        }
        return compatMap.get(mod);
    }

    private static void ifModLoaded(String mod, Runnable fn) {
        if (Compat.isCompatEnabled(mod) && ModList.get().isLoaded(mod)) {
            fn.run();
        }
    }
}

