/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.client;

import juuxel.adorn.client.gui.TradeTooltipComponent;
import juuxel.adorn.client.gui.screen.AdornMenuScreens;
import juuxel.adorn.client.gui.screen.GuideBookScreen;
import juuxel.adorn.client.gui.screen.MainConfigScreen;
import juuxel.adorn.platform.PlatformBridges;
import juuxel.adorn.platform.forge.client.AdornRenderers;
import juuxel.adorn.trading.Trade;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

public final class AdornClient {
    public static void init(IEventBus modBus) {
        modBus.addListener(AdornClient::setup);
        modBus.addListener(AdornRenderers::registerRenderers);
        modBus.addListener(AdornClient::registerTooltipComponent);
        ReloadableResourceManager resourceManager = (ReloadableResourceManager)Minecraft.getInstance().getResourceManager();
        resourceManager.registerReloadListener((PreparableReloadListener)PlatformBridges.get().getResources().getBookManager());
        resourceManager.registerReloadListener((PreparableReloadListener)PlatformBridges.get().getResources().getColorManager());
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (container, parent) -> new MainConfigScreen(parent));
    }

    private static void setup(FMLClientSetupEvent event) {
        AdornMenuScreens.register();
    }

    private static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(Trade.class, TradeTooltipComponent::new);
    }

    public static void openBookScreen(ResourceLocation bookId) {
        Minecraft.getInstance().setScreen((Screen)new GuideBookScreen(PlatformBridges.get().getResources().getBookManager().get(bookId)));
    }
}

