/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.block.entity;

import juuxel.adorn.block.entity.KitchenSinkBlockEntity;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.platform.forge.block.entity.BlockEntityWithFluidTank;
import juuxel.adorn.platform.forge.util.FluidTankReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public final class KitchenSinkBlockEntityForge
extends KitchenSinkBlockEntity
implements BlockEntityWithFluidTank {
    private static final int BOTTLE_LITRES = 250;
    private static final FluidStack BOTTLE_WATER = new FluidStack((Fluid)Fluids.WATER, 250);
    private final FluidTank tank = new FluidTank(1000){

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (KitchenSinkBlockEntity.supportsInfiniteExtraction(KitchenSinkBlockEntityForge.this.getLevel(), this.fluid.getFluid())) {
                return this.fluid.copyWithAmount(Math.min(this.getFluidAmount(), maxDrain));
            }
            return super.drain(maxDrain, action);
        }

        protected void onContentsChanged() {
            KitchenSinkBlockEntityForge.this.markDirtyAndSync();
        }
    };
    private final FluidReference fluidReference = new FluidTankReference(this.tank);

    public KitchenSinkBlockEntityForge(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public FluidReference getFluidReference() {
        return this.fluidReference;
    }

    @Override
    public boolean interactWithItem(ItemStack stack, Player player, InteractionHand hand) {
        FluidActionResult result;
        if (this.tank.getSpace() > 0 && (result = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)this.tank, (int)this.tank.getSpace(), null, (boolean)true)).isSuccess()) {
            this.onFill(stack, player);
            this.setStackOrInsert(player, hand, result.result);
            this.markDirtyAndSync();
            return true;
        }
        FluidVolume tankFluid = this.fluidReference.createSnapshot();
        FluidActionResult result2 = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)this.tank, (int)this.tank.getFluidAmount(), null, (boolean)true);
        if (result2.isSuccess()) {
            this.onPickUp(tankFluid, stack, player);
            this.setStackOrInsert(player, hand, result2.result);
            this.markDirtyAndSync();
            return true;
        }
        if (stack.is(Items.GLASS_BOTTLE)) {
            FluidStack drainingResult = this.tank.drain(BOTTLE_WATER, IFluidHandler.FluidAction.SIMULATE);
            if (drainingResult.getAmount() >= 250) {
                this.tank.drain(BOTTLE_WATER, IFluidHandler.FluidAction.EXECUTE);
                this.onPickUp(tankFluid, stack, player);
                ItemStack bottle = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);
                this.setStackOrInsert(player, hand, bottle);
                return true;
            }
        } else if (stack.is(Items.POTION)) {
            boolean spaceForWater;
            boolean bl = spaceForWater = this.tank.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)this.tank.getFluid(), (FluidStack)BOTTLE_WATER) && this.tank.getSpace() >= 250;
            if (spaceForWater && KitchenSinkBlockEntityForge.isWaterBottle(stack)) {
                this.onFill(stack, player);
                this.tank.fill(BOTTLE_WATER.copy(), IFluidHandler.FluidAction.EXECUTE);
                this.setStackOrInsert(player, hand, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                this.markDirtyAndSync();
                return true;
            }
        }
        return false;
    }

    private void setStackOrInsert(Player player, InteractionHand hand, ItemStack stack) {
        ItemStack current = player.getItemInHand(hand);
        current.shrink(1);
        if (current.isEmpty()) {
            player.setItemInHand(hand, stack);
        } else {
            player.getInventory().placeItemBackInInventory(stack);
        }
    }

    @Override
    public boolean clearFluidsWithSponge() {
        if (!this.tank.getFluid().getFluid().is(FluidTags.WATER) || this.tank.isEmpty()) {
            return false;
        }
        this.tank.getFluid().setAmount(0);
        this.markDirtyAndSync();
        return true;
    }

    @Override
    protected KitchenSinkBlockEntity.FluidItemSound getFillSound(FluidReference fluid, ItemStack stack) {
        return super.getFillSound(fluid, stack).orElse(fluid.getFluid().getFluidType().getSound(FluidTankReference.toFluidStack(fluid), SoundActions.BUCKET_FILL));
    }

    @Override
    protected KitchenSinkBlockEntity.FluidItemSound getEmptySound(FluidReference fluid, ItemStack stack) {
        return super.getEmptySound(fluid, stack).orElse(fluid.getFluid().getFluidType().getSound(FluidTankReference.toFluidStack(fluid), SoundActions.BUCKET_EMPTY));
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.tank.readFromNBT(registries, nbt);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.tank.writeToNBT(registries, nbt);
    }

    @Override
    public int calculateComparatorOutput() {
        return this.tank.isEmpty() ? 0 : 1 + Mth.floor((float)(14.0f * (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity()));
    }
}

