/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import juuxel.adorn.item.group.ItemGroupModifyContext;
import juuxel.adorn.platform.ItemGroupBridge;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public final class ItemGroupBridgeForge
implements ItemGroupBridge {
    private static final CreativeModeTab.TabVisibility DEFAULT_STACK_VISIBILITY = CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS;
    private final List<Pair<ResourceKey<CreativeModeTab>, Consumer<ItemGroupModifyContext>>> additions = new ArrayList<Pair<ResourceKey<CreativeModeTab>, Consumer<ItemGroupModifyContext>>>();

    @Override
    public CreativeModeTab.Builder builder() {
        return CreativeModeTab.builder();
    }

    @Override
    public void addItems(ResourceKey<CreativeModeTab> group, Consumer<ItemGroupModifyContext> configurator) {
        this.additions.add((Pair<ResourceKey<CreativeModeTab>, Consumer<ItemGroupModifyContext>>)new Pair(group, configurator));
    }

    @SubscribeEvent
    public void addToGroups(final BuildCreativeModeTabContentsEvent event) {
        for (Pair<ResourceKey<CreativeModeTab>, Consumer<ItemGroupModifyContext>> entry : this.additions) {
            final ResourceKey group = (ResourceKey)entry.getFirst();
            Consumer configurator = (Consumer)entry.getSecond();
            ItemGroupModifyContext context = new ItemGroupModifyContext(){

                @Override
                public void add(ItemLike item) {
                    if (event.getTabKey().equals(group)) {
                        event.accept(item);
                    }
                }

                @Override
                public void addBefore(ItemLike before, List<? extends ItemLike> items) {
                    if (event.getTabKey().equals(group)) {
                        ItemStack beforeStack = new ItemStack(before);
                        for (ItemLike item : items.reversed()) {
                            ItemStack stack = new ItemStack(item);
                            event.insertBefore(beforeStack, stack, DEFAULT_STACK_VISIBILITY);
                            beforeStack = stack;
                        }
                    }
                }

                @Override
                public void addAfter(ItemLike after, List<? extends ItemLike> items) {
                    if (event.getTabKey().equals(group)) {
                        ItemStack afterStack = new ItemStack(after);
                        for (ItemLike itemLike : items) {
                            ItemStack stack = new ItemStack(itemLike);
                            event.insertAfter(afterStack, stack, DEFAULT_STACK_VISIBILITY);
                            afterStack = stack;
                        }
                    }
                }
            };
            configurator.accept(context);
        }
    }
}

