/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge;

import juuxel.adorn.fluid.FluidAmountPredicate;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.fluid.HasFluidAmount;
import juuxel.adorn.platform.FluidBridge;
import juuxel.adorn.platform.forge.util.FluidTankReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public final class FluidBridgeForge
implements FluidBridge {
    @Override
    public FluidUnit getFluidUnit() {
        return FluidUnit.LITRE;
    }

    @Override
    @Nullable
    public FluidVolume drain(Level world, BlockPos pos, @Nullable BlockState state, Direction side, Fluid fluid, FluidAmountPredicate amountPredicate) {
        HasFluidAmount upperBound;
        int maxAmount;
        FluidStack max;
        FluidStack extracted;
        IFluidHandler fluidHandler = (IFluidHandler)world.getCapability(Capabilities.FluidHandler.BLOCK, pos, state, null, (Object)side);
        if (fluidHandler != null && !(extracted = fluidHandler.drain(max = new FluidStack(fluid, maxAmount = (int)FluidUnit.convert((upperBound = amountPredicate.getUpperBound()).getAmount(), upperBound.getUnit(), FluidUnit.LITRE)), IFluidHandler.FluidAction.SIMULATE)).isEmpty() && amountPredicate.test(extracted.getAmount(), FluidUnit.LITRE)) {
            fluidHandler.drain(extracted, IFluidHandler.FluidAction.EXECUTE);
            return FluidTankReference.toFluidVolume(extracted);
        }
        return null;
    }
}

